/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class InvUtils {
    private InvUtils() {
    }

    public static int countItems(IInventory inv, ForgeDirection side, IStackFilter filter) {
        int count = 0;
        for (IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            count += stack.stackSize;
        }
        return count;
    }

    public static boolean containsItem(IInventory inv, ForgeDirection side, IStackFilter filter) {
        for (IInvSlot slot : InventoryIterator.getIterable(inv, side)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !filter.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoomForStack(ItemStack stack, ForgeDirection side, IInventory dest) {
        if (stack == null || dest == null) {
            return false;
        }
        ITransactor tran = Transactor.getTransactorFor(dest);
        return tran.add((ItemStack)stack, (ForgeDirection)side, (boolean)false).stackSize > 0;
    }

    public static ItemStack moveOneItem(IInventory source, ForgeDirection output, IInventory dest, ForgeDirection intput, IStackFilter filter) {
        ITransactor imSource = Transactor.getTransactorFor(source);
        ItemStack stack = imSource.remove(filter, output, false);
        if (stack != null) {
            ITransactor imDest = Transactor.getTransactorFor(dest);
            int moved = imDest.add((ItemStack)stack, (ForgeDirection)intput, (boolean)true).stackSize;
            if (moved > 0) {
                imSource.remove(filter, output, true);
                return stack;
            }
        }
        return null;
    }

    public static void dropItems(World world, ItemStack stack, int i, int j, int k) {
        if (stack == null || stack.stackSize <= 0) {
            return;
        }
        float f1 = 0.7f;
        double d = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.rand.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static void dropItems(World world, IInventory inv, int i, int j, int k) {
        for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
            ItemStack items = inv.getStackInSlot(slot);
            if (items == null || items.stackSize <= 0) continue;
            InvUtils.dropItems(world, inv.getStackInSlot(slot).copy(), i, j, k);
        }
    }

    public static void wipeInventory(IInventory inv) {
        for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
            inv.setInventorySlotContents(slot, null);
        }
    }

    public static NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.getTagCompound();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.setTagCompound(nbt);
        }
        return nbt;
    }

    public static void addItemToolTip(ItemStack stack, String msg) {
        NBTTagCompound nbt = InvUtils.getItemData(stack);
        NBTTagCompound display = nbt.getCompoundTag("display");
        nbt.setTag("display", (NBTBase)display);
        NBTTagList lore = display.getTagList("Lore", 8);
        display.setTag("Lore", (NBTBase)lore);
        lore.appendTag((NBTBase)new NBTTagString(msg));
    }

    public static void writeInvToNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (byte slot = 0; slot < inv.getSizeInventory(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inv.getStackInSlot((int)slot);
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.setByte("Slot", slot);
            stack.writeToNBT(itemTag);
            list.appendTag((NBTBase)itemTag);
        }
        data.setTag(tag, (NBTBase)list);
    }

    public static void readInvFromNBT(IInventory inv, String tag, NBTTagCompound data) {
        NBTTagList list = data.getTagList(tag, 10);
        for (int entry = 0; entry < list.tagCount(); entry = (int)((byte)(entry + 1))) {
            NBTTagCompound itemTag = list.getCompoundTagAt(entry);
            byte slot = itemTag.getByte("Slot");
            if (slot < 0 || slot >= inv.getSizeInventory()) continue;
            ItemStack stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag);
            inv.setInventorySlotContents((int)slot, stack);
        }
    }

    public static void readStacksFromNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = nbt.getTagList(name, 10);
        for (int i = 0; i < stacks.length; ++i) {
            if (i < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(i);
                stacks[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound2);
                continue;
            }
            stacks[i] = null;
        }
    }

    public static void writeStacksToNBT(NBTTagCompound nbt, String name, ItemStack[] stacks) {
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound cpt = new NBTTagCompound();
            nbttaglist.appendTag((NBTBase)cpt);
            if (stack == null) continue;
            stack.writeToNBT(cpt);
        }
        nbt.setTag(name, (NBTBase)nbttaglist);
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.stackSize == 1) {
            if (stack.getItem().hasContainerItem(stack)) {
                return stack.getItem().getContainerItem(stack);
            }
            return null;
        }
        stack.splitStack(1);
        return stack;
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            if (chest.adjacentChestXNeg != null) {
                adjacent = chest.adjacentChestXNeg;
            }
            if (chest.adjacentChestXPos != null) {
                adjacent = chest.adjacentChestXPos;
            }
            if (chest.adjacentChestZNeg != null) {
                adjacent = chest.adjacentChestZNeg;
            }
            if (chest.adjacentChestZPos != null) {
                adjacent = chest.adjacentChestZPos;
            }
            if (adjacent != null) {
                return new InventoryLargeChest("", inv, (IInventory)adjacent);
            }
            return inv;
        }
        return inv;
    }

    public static IInvSlot getItem(IInventory inv, IStackFilter filter) {
        for (IInvSlot s : InventoryIterator.getIterable(inv)) {
            if (s.getStackInSlot() == null || !filter.matches(s.getStackInSlot())) continue;
            return s;
        }
        return null;
    }
}

