/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.core.utils.INBTTagable;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class SimpleInventory
implements IInventory,
INBTTagable {
    private final ItemStack[] contents;
    private final String name;
    private final int stackLimit;
    private final LinkedList<TileEntity> listener = new LinkedList();

    public SimpleInventory(int size, String invName, int invStackLimit) {
        this.contents = new ItemStack[size];
        this.name = invName;
        this.stackLimit = invStackLimit;
    }

    public int getSizeInventory() {
        return this.contents.length;
    }

    public ItemStack getStackInSlot(int slotId) {
        return this.contents[slotId];
    }

    public ItemStack decrStackSize(int slotId, int count) {
        if (slotId < this.contents.length && this.contents[slotId] != null) {
            if (this.contents[slotId].stackSize > count) {
                ItemStack result = this.contents[slotId].splitStack(count);
                this.markDirty();
                return result;
            }
            ItemStack stack = this.contents[slotId];
            this.setInventorySlotContents(slotId, null);
            return stack;
        }
        return null;
    }

    public void setInventorySlotContents(int slotId, ItemStack itemstack) {
        if (slotId >= this.contents.length) {
            return;
        }
        this.contents[slotId] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return this.name;
    }

    public int getInventoryStackLimit() {
        return this.stackLimit;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        if (data.hasKey("items")) {
            this.readFromNBT(data, "items");
        } else {
            this.readFromNBT(data, "Items");
        }
    }

    public void readFromNBT(NBTTagCompound data, String tag) {
        NBTTagList nbttaglist = data.getTagList(tag, 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            NBTTagCompound slot = nbttaglist.getCompoundTagAt(j);
            int index = slot.hasKey("index") ? slot.getInteger("index") : (int)slot.getByte("Slot");
            if (index < 0 || index >= this.contents.length) continue;
            this.setInventorySlotContents(index, ItemStack.loadItemStackFromNBT((NBTTagCompound)slot));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBT(data, "Items");
    }

    public void writeToNBT(NBTTagCompound data, String tag) {
        NBTTagList slots = new NBTTagList();
        for (byte index = 0; index < this.contents.length; index = (byte)((byte)(index + 1))) {
            if (this.contents[index] == null || this.contents[index].stackSize <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            slots.appendTag((NBTBase)slot);
            slot.setByte("Slot", index);
            this.contents[index].writeToNBT(slot);
        }
        data.setTag(tag, (NBTBase)slots);
    }

    public void addListener(TileEntity listner) {
        this.listener.add(listner);
    }

    public ItemStack getStackInSlotOnClosing(int slotId) {
        if (this.contents[slotId] == null) {
            return null;
        }
        ItemStack stackToTake = this.contents[slotId];
        this.setInventorySlotContents(slotId, null);
        return stackToTake;
    }

    public ItemStack[] getItemStacks() {
        return this.contents;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public void markDirty() {
        for (TileEntity handler : this.listener) {
            handler.markDirty();
        }
    }
}

