/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.TransactorSimple;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TransactorRoundRobin
extends TransactorSimple {
    public TransactorRoundRobin(IInventory inventory) {
        super(inventory);
    }

    @Override
    public int inject(ItemStack stack, ForgeDirection orientation, boolean doAdd) {
        int added = 0;
        for (int itemLoop = 0; itemLoop < stack.stackSize; ++itemLoop) {
            int smallestStackSize = Integer.MAX_VALUE;
            IInvSlot minSlot = null;
            for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
                ItemStack stackInInventory = slot.getStackInSlot();
                if (stackInInventory == null || stackInInventory.stackSize >= stackInInventory.getMaxStackSize() || stackInInventory.stackSize >= this.inventory.getInventoryStackLimit()) continue;
                if (StackHelper.canStacksMerge(stack, stackInInventory) && stackInInventory.stackSize < smallestStackSize) {
                    smallestStackSize = stackInInventory.stackSize;
                    minSlot = slot;
                }
                if (smallestStackSize > 1) continue;
                break;
            }
            if (minSlot == null) break;
            added += this.addToSlot(minSlot, stack, stack.stackSize - 1, doAdd);
        }
        return added;
    }
}

