/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TransactorSimple
extends Transactor {
    protected IInventory inventory;

    public TransactorSimple(IInventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public int inject(ItemStack stack, ForgeDirection orientation, boolean doAdd) {
        ArrayList<IInvSlot> filledSlots = new ArrayList<IInvSlot>(this.inventory.getSizeInventory());
        ArrayList<IInvSlot> emptySlots = new ArrayList<IInvSlot>(this.inventory.getSizeInventory());
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            if (!slot.canPutStackInSlot(stack)) continue;
            if (slot.getStackInSlot() == null) {
                emptySlots.add(slot);
                continue;
            }
            filledSlots.add(slot);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        injected = this.tryPut(stack, emptySlots, injected, doAdd);
        this.inventory.markDirty();
        return injected;
    }

    private int tryPut(ItemStack stack, List<IInvSlot> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        if (realInjected >= stack.stackSize) {
            return realInjected;
        }
        for (IInvSlot slot : slots) {
            int used;
            ItemStack stackInSlot = slot.getStackInSlot();
            if (stackInSlot != null && !StackHelper.canStacksMerge(stackInSlot, stack) || (used = this.addToSlot(slot, stack, realInjected, doAdd)) <= 0 || (realInjected += used) < stack.stackSize) continue;
            return realInjected;
        }
        return realInjected;
    }

    protected int addToSlot(IInvSlot slot, ItemStack stack, int injected, boolean doAdd) {
        int available = stack.stackSize - injected;
        int max = Math.min(stack.getMaxStackSize(), this.inventory.getInventoryStackLimit());
        ItemStack stackInSlot = slot.getStackInSlot();
        if (stackInSlot == null) {
            int wanted = Math.min(available, max);
            if (doAdd) {
                stackInSlot = stack.copy();
                stackInSlot.stackSize = wanted;
                slot.setStackInSlot(stackInSlot);
            }
            return wanted;
        }
        if (!StackHelper.canStacksMerge(stack, stackInSlot)) {
            return 0;
        }
        int wanted = max - stackInSlot.stackSize;
        if (wanted <= 0) {
            return 0;
        }
        if (wanted > available) {
            wanted = available;
        }
        if (doAdd) {
            stackInSlot.stackSize += wanted;
            slot.setStackInSlot(stackInSlot);
        }
        return wanted;
    }

    @Override
    public ItemStack remove(IStackFilter filter, ForgeDirection orientation, boolean doRemove) {
        for (IInvSlot slot : InventoryIterator.getIterable(this.inventory, orientation)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack)) continue;
            if (doRemove) {
                return slot.decreaseStackInSlot(1);
            }
            ItemStack output = stack.copy();
            output.stackSize = 1;
            return output;
        }
        return null;
    }
}

