/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.inventory.filters;

import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.filters.IStackFilter;
import net.minecraft.item.ItemStack;

public class ArrayStackFilter
implements IStackFilter {
    protected ItemStack[] stacks;

    public ArrayStackFilter(ItemStack ... stacks) {
        this.stacks = stacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (this.stacks.length == 0 || !this.hasFilter()) {
            return true;
        }
        for (ItemStack s : this.stacks) {
            if (!StackHelper.isMatchingItem(s, stack)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(IStackFilter filter2) {
        for (ItemStack s : this.stacks) {
            if (!filter2.matches(s)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }
}

