/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.CommandTarget;
import buildcraft.core.network.CommandTargetContainer;
import buildcraft.core.network.CommandTargetEntity;
import buildcraft.core.network.CommandTargetTile;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class PacketCommand
extends BuildCraftPacket {
    public static final ArrayList<CommandTarget> targets = new ArrayList();
    public ByteBuf stream;
    public String command;
    public Object target;
    public CommandTarget handler;
    private CommandWriter writer;

    public PacketCommand() {
    }

    public PacketCommand(Object target, String command, CommandWriter writer) {
        this.target = target;
        this.command = command;
        this.writer = writer;
        this.isChunkDataPacket = true;
        for (CommandTarget c : targets) {
            if (!c.getHandledClass().isAssignableFrom(target.getClass())) continue;
            this.handler = c;
            break;
        }
    }

    public void handle(EntityPlayer player) {
        ICommandReceiver receiver;
        if (this.handler != null && (receiver = this.handler.handle(player, this.stream, player.worldObj)) != null) {
            receiver.receiveCommand(this.command, FMLCommonHandler.instance().getEffectiveSide(), player, this.stream);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        Utils.writeUTF(data, this.command);
        data.writeByte(targets.indexOf(this.handler));
        this.handler.write(data, this.target);
        if (this.writer != null) {
            this.writer.write(data);
        }
    }

    @Override
    public void readData(ByteBuf data) {
        this.command = Utils.readUTF(data);
        this.handler = targets.get(data.readUnsignedByte());
        this.stream = data;
    }

    @Override
    public int getID() {
        return 1;
    }

    static {
        targets.add(new CommandTargetTile());
        targets.add(new CommandTargetEntity());
        targets.add(new CommandTargetContainer());
    }
}

