/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.Box;
import buildcraft.core.DefaultProps;
import buildcraft.core.IBoxProvider;
import buildcraft.core.IBoxesProvider;
import buildcraft.core.render.RenderBox;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderBoxProvider
extends TileEntitySpecialRenderer {
    private static final ResourceLocation LASER_RED = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_1.png");
    private static final ResourceLocation LASER_YELLOW = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_2.png");
    private static final ResourceLocation LASER_GREEN = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_3.png");
    private static final ResourceLocation LASER_BLUE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/laser_4.png");
    private static final ResourceLocation STRIPES = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/stripes.png");
    private static final ResourceLocation BLUE_STRIPES = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/blue_stripes.png");

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-tileentity.xCoord), (double)(-tileentity.yCoord), (double)(-tileentity.zCoord));
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (tileentity instanceof IBoxesProvider) {
            for (Box b : ((IBoxesProvider)tileentity).getBoxes()) {
                if (!b.isVisible) continue;
                RenderBox.doRender(TileEntityRendererDispatcher.instance.field_147553_e, this.getTexture(b.kind), b);
            }
        } else if (tileentity instanceof IBoxProvider) {
            Box b = ((IBoxProvider)tileentity).getBox();
            if (b.isVisible) {
                RenderBox.doRender(TileEntityRendererDispatcher.instance.field_147553_e, this.getTexture(b.kind), b);
            }
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private ResourceLocation getTexture(Box.Kind kind) {
        switch (kind) {
            case LASER_RED: {
                return LASER_RED;
            }
            case LASER_YELLOW: {
                return LASER_YELLOW;
            }
            case LASER_GREEN: {
                return LASER_GREEN;
            }
            case LASER_BLUE: {
                return LASER_BLUE;
            }
            case STRIPES: {
                return STRIPES;
            }
            case BLUE_STRIPES: {
                return BLUE_STRIPES;
            }
        }
        return null;
    }
}

