/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.core.EntityBlock;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public final class RenderEntityBlock
extends Render {
    public static RenderEntityBlock INSTANCE = new RenderEntityBlock();
    protected RenderBlocks renderBlocks;

    private RenderEntityBlock() {
        this.renderBlocks = this.field_147909_c;
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doRender(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRenderBlock((EntityBlock)entity, x, y, z);
    }

    public void doRenderBlock(EntityBlock entity, double x, double y, double z) {
        if (entity.isDead) {
            return;
        }
        this.shadowSize = entity.shadowSize;
        RenderInfo util = new RenderInfo();
        util.texture = entity.texture;
        this.bindTexture(TextureMap.locationBlocksTexture);
        int iBase = 0;
        while ((double)iBase < entity.iSize) {
            int jBase = 0;
            while ((double)jBase < entity.jSize) {
                int kBase = 0;
                while ((double)kBase < entity.kSize) {
                    util.minX = 0.0;
                    util.minY = 0.0;
                    util.minZ = 0.0;
                    double remainX = entity.iSize - (double)iBase;
                    double remainY = entity.jSize - (double)jBase;
                    double remainZ = entity.kSize - (double)kBase;
                    util.maxX = remainX > 1.0 ? 1.0 : remainX;
                    util.maxY = remainY > 1.0 ? 1.0 : remainY;
                    util.maxZ = remainZ > 1.0 ? 1.0 : remainZ;
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
                    GL11.glRotatef((float)entity.rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)entity.rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)iBase, (float)jBase, (float)kBase);
                    this.renderBlock(util);
                    GL11.glPopMatrix();
                    ++kBase;
                }
                ++jBase;
            }
            ++iBase;
        }
    }

    public void renderBlock(RenderInfo info) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        this.renderBlocks.setRenderBounds(info.minX, info.minY, info.minZ, info.maxX, info.maxY, info.maxZ);
        if (info.renderSide[0]) {
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBlocks.renderFaceYNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(0));
        }
        if (info.renderSide[1]) {
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderBlocks.renderFaceYPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(1));
        }
        if (info.renderSide[2]) {
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderBlocks.renderFaceZNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(2));
        }
        if (info.renderSide[3]) {
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderBlocks.renderFaceZPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(3));
        }
        if (info.renderSide[4]) {
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderBlocks.renderFaceXNeg(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(4));
        }
        if (info.renderSide[5]) {
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderBlocks.renderFaceXPos(info.baseBlock, 0.0, 0.0, 0.0, info.getBlockTextureFromSide(5));
        }
        tessellator.draw();
    }

    public static class RenderInfo {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public Block baseBlock = Blocks.sand;
        public IIcon texture = null;
        public IIcon[] textureArray = null;
        public boolean[] renderSide = new boolean[6];
        public float light = -1.0f;
        public int brightness = -1;

        public RenderInfo() {
            this.setRenderAllSides();
        }

        public RenderInfo(Block template, IIcon[] texture) {
            this();
            this.baseBlock = template;
            this.textureArray = texture;
        }

        public RenderInfo(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this();
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
            return this.baseBlock.getMixedBrightnessForBlock(iblockaccess, i, j, k);
        }

        public final void setBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public final void setRenderSingleSide(int side) {
            Arrays.fill(this.renderSide, false);
            this.renderSide[side] = true;
        }

        public final void setRenderAllSides() {
            Arrays.fill(this.renderSide, true);
        }

        public void rotate() {
            double temp = this.minX;
            this.minX = this.minZ;
            this.minZ = temp;
            temp = this.maxX;
            this.maxX = this.maxZ;
            this.maxZ = temp;
        }

        public void reverseX() {
            double temp = this.minX;
            this.minX = 1.0 - this.maxX;
            this.maxX = 1.0 - temp;
        }

        public void reverseZ() {
            double temp = this.minZ;
            this.minZ = 1.0 - this.maxZ;
            this.maxZ = 1.0 - temp;
        }

        public IIcon getBlockTextureFromSide(int i) {
            if (this.texture != null) {
                return this.texture;
            }
            int index = i;
            if (this.textureArray == null || this.textureArray.length == 0) {
                return this.baseBlock.getBlockTextureFromSide(index);
            }
            if (index >= this.textureArray.length) {
                index = 0;
            }
            return this.textureArray[index];
        }
    }
}

