/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.api.core.Position;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.render.RenderEntityBlock;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderLaser
extends Render {
    public static final float STEP = 0.04f;
    protected static ModelBase model = new ModelBase(){};
    private static ModelRenderer[] box;
    private static int[][] scaledBoxes;

    private static ModelRenderer getBox(int index) {
        if (box == null) {
            box = new ModelRenderer[40];
            for (int j = 0; j < box.length; ++j) {
                RenderLaser.box[j] = new ModelRenderer(model, box.length - j, 0);
                box[j].addBox(0.0f, -0.5f, -0.5f, 16, 1, 1);
                RenderLaser.box[j].rotationPointX = 0.0f;
                RenderLaser.box[j].rotationPointY = 0.0f;
                RenderLaser.box[j].rotationPointZ = 0.0f;
            }
        }
        return box[index];
    }

    private static void initScaledBoxes() {
        if (scaledBoxes == null) {
            scaledBoxes = new int[100][20];
            for (int size = 0; size < 100; ++size) {
                for (int i = 0; i < 20; ++i) {
                    RenderLaser.scaledBoxes[size][i] = GLAllocation.generateDisplayLists((int)1);
                    GL11.glNewList((int)scaledBoxes[size][i], (int)4864);
                    RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
                    float minSize = 0.2f * (float)size / 100.0f;
                    float maxSize = 0.4f * (float)size / 100.0f;
                    float range = maxSize - minSize;
                    float diff = (float)(Math.cos((double)((float)i / 20.0f * 2.0f) * Math.PI) * (double)range / 2.0);
                    block.minX = 0.0;
                    block.minY = -maxSize / 2.0f + diff;
                    block.minZ = -maxSize / 2.0f + diff;
                    block.maxX = 0.04f;
                    block.maxY = maxSize / 2.0f - diff;
                    block.maxZ = maxSize / 2.0f - diff;
                    RenderEntityBlock.INSTANCE.renderBlock(block);
                    GL11.glEndList();
                }
            }
        }
    }

    public void doRender(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRender((EntityLaser)entity, x, y, z, f, f1);
    }

    private void doRender(EntityLaser laser, double x, double y, double z, float f, float f1) {
        if (!laser.isVisible() || laser.getTexture() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        Position offset = laser.renderOffset();
        GL11.glTranslated((double)(x + offset.x), (double)(y + offset.y), (double)(z + offset.z));
        RenderLaser.doRenderLaser(this.renderManager.renderEngine, laser.data, laser.getTexture());
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void doRenderLaserWave(TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.x, (double)laser.head.y, (double)laser.head.z);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.bindTexture(texture);
        int indexList = 0;
        RenderLaser.initScaledBoxes();
        double x1 = laser.wavePosition;
        double x2 = x1 + (double)((float)scaledBoxes[0].length * 0.04f);
        double x3 = laser.renderSize;
        RenderLaser.doRenderLaserLine(x1, laser.laserTexAnimation);
        for (double i = x1; i <= x2 && i <= laser.renderSize; i += (double)0.04f) {
            GL11.glCallList((int)scaledBoxes[(int)(laser.waveSize * 99.0f)][indexList]);
            indexList = (indexList + 1) % scaledBoxes[0].length;
            GL11.glTranslated((double)0.04f, (double)0.0, (double)0.0);
        }
        if (x2 < x3) {
            RenderLaser.doRenderLaserLine(x3 - x2, laser.laserTexAnimation);
        }
        GL11.glPopMatrix();
    }

    public static void doRenderLaser(TextureManager textureManager, LaserData laser, ResourceLocation texture) {
        if (!laser.isVisible || texture == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)laser.head.x, (double)laser.head.y, (double)laser.head.z);
        laser.update();
        GL11.glRotatef((float)((float)laser.angleZ), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)laser.angleY), (float)0.0f, (float)0.0f, (float)1.0f);
        textureManager.bindTexture(texture);
        RenderLaser.initScaledBoxes();
        RenderLaser.doRenderLaserLine(laser.renderSize, laser.laserTexAnimation);
        GL11.glPopMatrix();
    }

    private static void doRenderLaserLine(double len, int texId) {
        float lasti = 0.0f;
        if (len - 1.0 > 0.0) {
            float i = 0.0f;
            while ((double)i <= len - 1.0) {
                RenderLaser.getBox(texId).render(0.0625f);
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                lasti = i;
                i += 1.0f;
            }
            lasti += 1.0f;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)((float)len - lasti), (float)1.0f, (float)1.0f);
        RenderLaser.getBox(texId).render(0.0625f);
        GL11.glPopMatrix();
        GL11.glTranslated((double)((float)(len - (double)lasti)), (double)0.0, (double)0.0);
    }

    protected ResourceLocation getEntityTexture(Entity entity) {
        return ((EntityLaser)entity).getTexture();
    }
}

