/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.IInventoryRenderer;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderingEntityBlocks
implements ISimpleBlockRenderingHandler {
    public static HashMap<EntityRenderIndex, IInventoryRenderer> blockByEntityRenders = new HashMap();
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.locationBlocksTexture;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (block.getRenderType() == BuildCraftCore.blockByEntityModel) {
            EntityRenderIndex index = new EntityRenderIndex(block, metadata);
            if (blockByEntityRenders.containsKey(index)) {
                blockByEntityRenders.get(index).inventoryRender(-0.5, -0.5, -0.5, 0.0f, 0.0f);
            }
        } else if (block.getRenderType() == BuildCraftCore.legacyPipeModel) {
            Tessellator tessellator = Tessellator.instance;
            block.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
            renderer.setRenderBoundsFromBlock(block);
            block.setBlockBoundsForItemRender();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, block.getIcon(0, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, block.getIcon(1, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, block.getIcon(2, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, block.getIcon(3, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, block.getIcon(4, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, block.getIcon(5, metadata));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (block.getRenderType() != BuildCraftCore.blockByEntityModel && block.getRenderType() == BuildCraftCore.legacyPipeModel) {
            Minecraft.getMinecraft().renderEngine.bindTexture(BLOCK_TEXTURE);
            this.legacyPipeRender(renderer, world, x, y, z, block, modelId);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BuildCraftCore.blockByEntityModel;
    }

    private void legacyPipeRender(RenderBlocks renderblocks, IBlockAccess iblockaccess, int i, int j, int k, Block block, int l) {
        float minSize = 0.25f;
        float maxSize = 0.75f;
        block.setBlockBounds(minSize, minSize, minSize, maxSize, maxSize, maxSize);
        renderblocks.setRenderBoundsFromBlock(block);
        renderblocks.renderStandardBlock(block, i, j, k);
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i - 1, j, k)) {
            block.setBlockBounds(0.0f, minSize, minSize, minSize, maxSize, maxSize);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i + 1, j, k)) {
            block.setBlockBounds(maxSize, minSize, minSize, 1.0f, maxSize, maxSize);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j - 1, k)) {
            block.setBlockBounds(minSize, 0.0f, minSize, maxSize, minSize, maxSize);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j + 1, k)) {
            block.setBlockBounds(minSize, maxSize, minSize, maxSize, 1.0f, maxSize);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j, k - 1)) {
            block.setBlockBounds(minSize, minSize, 0.0f, maxSize, maxSize, minSize);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        if (Utils.checkLegacyPipesConnections(iblockaccess, i, j, k, i, j, k + 1)) {
            block.setBlockBounds(minSize, minSize, maxSize, maxSize, maxSize, 1.0f);
            renderblocks.setRenderBoundsFromBlock(block);
            renderblocks.renderStandardBlock(block, i, j, k);
        }
        block.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public static class EntityRenderIndex {
        Block block;
        int damage;

        public EntityRenderIndex(Block block, int damage) {
            this.block = block;
            this.damage = damage;
        }

        public int hashCode() {
            return this.block.hashCode() + this.damage;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EntityRenderIndex)) {
                return false;
            }
            EntityRenderIndex i = (EntityRenderIndex)o;
            return i.block == this.block && i.damage == this.damage;
        }
    }
}

