/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftFactory;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static List<ItemStack> getItemStackFromBlock(WorldServer world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        if (block == null || block.isAir((IBlockAccess)world, i, j, k)) {
            return null;
        }
        int meta = world.getBlockMetadata(i, j, k);
        ArrayList dropsList = block.getDrops((World)world, i, j, k, meta, 0);
        float dropChance = ForgeEventFactory.fireBlockHarvesting((ArrayList)dropsList, (World)world, (Block)block, (int)i, (int)j, (int)k, (int)meta, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get()));
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.rand.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z) {
        return BlockUtils.breakBlock(world, x, y, z, BuildCraftCore.itemLifespan);
    }

    public static boolean breakBlock(WorldServer world, int x, int y, int z, int forcedLifespan) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(x, y, z, (World)world, world.getBlock(x, y, z), world.getBlockMetadata(x, y, z), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world).get());
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!world.isAirBlock(x, y, z) && !world.isRemote && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            List<ItemStack> items = BlockUtils.getItemStackFromBlock(world, x, y, z);
            for (ItemStack item : items) {
                BlockUtils.dropItem(world, x, y, z, forcedLifespan, item);
            }
        }
        world.setBlockToAir(x, y, z);
        return true;
    }

    public static void dropItem(WorldServer world, int x, int y, int z, int forcedLifespan, ItemStack stack) {
        float var = 0.7f;
        double dx = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dy = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dz = (double)(world.rand.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        EntityItem entityitem = new EntityItem((World)world, (double)x + dx, (double)y + dy, (double)z + dz, stack);
        entityitem.lifespan = forcedLifespan;
        entityitem.delayBeforeCanPickup = 10;
        world.spawnEntityInWorld((Entity)entityitem);
    }

    public static boolean isAnObstructingBlock(Block block, World world, int x, int y, int z) {
        return block != null && !block.isAir((IBlockAccess)world, x, y, z);
    }

    public static boolean canChangeBlock(World world, int x, int y, int z) {
        return BlockUtils.canChangeBlock(world.getBlock(x, y, z), world, x, y, z);
    }

    public static boolean canChangeBlock(Block block, World world, int x, int y, int z) {
        if (block == null || block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block.getBlockHardness(world, x, y, z) < 0.0f) {
            return false;
        }
        if (block == BuildCraftEnergy.blockOil) {
            return false;
        }
        return block != Blocks.lava && block != Blocks.flowing_lava;
    }

    public static boolean isUnbreakableBlock(World world, int x, int y, int z) {
        Block b = world.getBlock(x, y, z);
        return b != null && b.getBlockHardness(world, x, y, z) < 0.0f;
    }

    public static boolean isToughBlock(World world, int x, int y, int z) {
        return !world.getBlock(x, y, z).getMaterial().isToolNotRequired();
    }

    public static boolean isFullFluidBlock(World world, int x, int y, int z) {
        return BlockUtils.isFullFluidBlock(world.getBlock(x, y, z), world, x, y, z);
    }

    public static boolean isFullFluidBlock(Block block, World world, int x, int y, int z) {
        if (block instanceof IFluidBlock || block instanceof BlockStaticLiquid) {
            return world.getBlockMetadata(x, y, z) == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack drainBlock(World world, int x, int y, int z, boolean doDrain) {
        return BlockUtils.drainBlock(world.getBlock(x, y, z), world, x, y, z, doDrain);
    }

    public static FluidStack drainBlock(Block block, World world, int x, int y, int z, boolean doDrain) {
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            int meta = world.getBlockMetadata(x, y, z);
            if (block instanceof IFluidBlock ? !((IFluidBlock)block).canDrain(world, x, y, z) : meta != 0) {
                return null;
            }
            if (doDrain) {
                world.setBlockToAir(x, y, z);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static void explodeBlock(World world, int x, int y, int z) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        Explosion explosion = new Explosion(world, null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f);
        explosion.affectedBlockPositions.add(new ChunkPosition(x, y, z));
        explosion.doExplosionB(true);
        for (EntityPlayer player : world.playerEntities) {
            if (!(player instanceof EntityPlayerMP) || !(player.getDistanceSq((double)x, (double)y, (double)z) < 4096.0)) continue;
            ((EntityPlayerMP)player).playerNetServerHandler.sendPacket((Packet)new S27PacketExplosion((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, explosion.affectedBlockPositions, null));
        }
    }

    public static int computeBlockBreakEnergy(World world, int x, int y, int z) {
        return (int)Math.floor(160.0f * BuildCraftFactory.miningMultiplier * ((world.getBlock(x, y, z).getBlockHardness(world, x, y, z) + 1.0f) * 2.0f));
    }

    public static TileEntity getTileEntity(World world, int x, int y, int z) {
        if (world.blockExists(x, y, z)) {
            return world.getChunkFromBlockCoords(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
        }
        return null;
    }
}

