/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.compat.CompatHooks;
import buildcraft.core.EntityBlock;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.IFramePipeConnection;
import buildcraft.core.LaserData;
import buildcraft.core.LaserKind;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.energy.TileEngine;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public final class Utils {
    public static final Random RANDOM = new Random();
    private static final List<ForgeDirection> directions = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));

    private Utils() {
    }

    public static int addToRandomInventoryAround(World world, int x, int y, int z, ItemStack stack) {
        Collections.shuffle(directions);
        for (ForgeDirection orientation : directions) {
            Position pos = new Position(x, y, z, orientation);
            pos.moveForwards(1.0);
            TileEntity tileInventory = BlockUtils.getTileEntity(world, (int)pos.x, (int)pos.y, (int)pos.z);
            ITransactor transactor = Transactor.getTransactorFor(tileInventory);
            if (transactor == null || tileInventory instanceof TileEngine || transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)false).stackSize <= 0) continue;
            return transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)true).stackSize;
        }
        return 0;
    }

    public static ForgeDirection get2dOrientation(EntityLivingBase entityliving) {
        ForgeDirection[] orientationTable = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
        int orientationIndex = MathHelper.floor_double((double)(((double)entityliving.rotationYaw + 45.0) / 90.0)) & 3;
        return orientationTable[orientationIndex];
    }

    @Deprecated
    private static ForgeDirection get2dOrientation(Position pos1, Position pos2) {
        double dZ = pos1.z - pos2.z;
        double dX = pos1.x - pos2.x;
        double angle = Math.atan2(dZ, dX) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return ForgeDirection.EAST;
        }
        if (angle < 135.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle < 225.0) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection get3dOrientation(Position pos1, Position pos2) {
        double dY = pos1.y - pos2.y;
        double dX = pos1.x - pos2.x;
        double angle = Math.atan2(dY, dX) / Math.PI * 180.0 + 180.0;
        if (angle > 45.0 && angle < 135.0) {
            return ForgeDirection.UP;
        }
        if (angle > 225.0 && angle < 315.0) {
            return ForgeDirection.DOWN;
        }
        return Utils.get2dOrientation(pos1, pos2);
    }

    public static int addToRandomInjectableAround(World world, int x, int y, int z, ForgeDirection from, ItemStack stack) {
        ArrayList<IInjectable> possiblePipes = new ArrayList<IInjectable>();
        ArrayList<ForgeDirection> pipeDirections = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (from.getOpposite() == side) continue;
            Position pos = new Position(x, y, z, side);
            pos.moveForwards(1.0);
            TileEntity tile = BlockUtils.getTileEntity(world, (int)pos.x, (int)pos.y, (int)pos.z);
            if (tile instanceof IInjectable) {
                if (!((IInjectable)tile).canInjectItems(side.getOpposite())) continue;
                possiblePipes.add((IInjectable)tile);
                pipeDirections.add(side.getOpposite());
                continue;
            }
            IInjectable wrapper = CompatHooks.INSTANCE.getInjectableWrapper(tile, side);
            if (wrapper == null) continue;
            possiblePipes.add(wrapper);
            pipeDirections.add(side.getOpposite());
        }
        if (possiblePipes.size() > 0) {
            int choice = RANDOM.nextInt(possiblePipes.size());
            IInjectable pipeEntry = (IInjectable)possiblePipes.get(choice);
            return pipeEntry.injectItem(stack, true, (ForgeDirection)pipeDirections.get(choice), null);
        }
        return 0;
    }

    public static void dropTryIntoPlayerInventory(World world, int x, int y, int z, ItemStack stack, EntityPlayer player) {
        if (player != null && player.inventory.addItemStackToInventory(stack) && player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
        }
        InvUtils.dropItems(world, stack, x, y, z);
    }

    public static TileEntity getTile(World world, Position pos, ForgeDirection step) {
        Position tmp = new Position(pos);
        tmp.orientation = step;
        tmp.moveForwards(1.0);
        return BlockUtils.getTileEntity(world, (int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    public static IAreaProvider getNearbyAreaProvider(World world, int i, int j, int k) {
        TileEntity a1 = BlockUtils.getTileEntity(world, i + 1, j, k);
        if (a1 instanceof IAreaProvider) {
            return (IAreaProvider)a1;
        }
        TileEntity a2 = BlockUtils.getTileEntity(world, i - 1, j, k);
        if (a2 instanceof IAreaProvider) {
            return (IAreaProvider)a2;
        }
        TileEntity a3 = BlockUtils.getTileEntity(world, i, j, k + 1);
        if (a3 instanceof IAreaProvider) {
            return (IAreaProvider)a3;
        }
        TileEntity a4 = BlockUtils.getTileEntity(world, i, j, k - 1);
        if (a4 instanceof IAreaProvider) {
            return (IAreaProvider)a4;
        }
        TileEntity a5 = BlockUtils.getTileEntity(world, i, j + 1, k);
        if (a5 instanceof IAreaProvider) {
            return (IAreaProvider)a5;
        }
        TileEntity a6 = BlockUtils.getTileEntity(world, i, j - 1, k);
        if (a6 instanceof IAreaProvider) {
            return (IAreaProvider)a6;
        }
        return null;
    }

    public static EntityBlock createLaser(World world, Position p1, Position p2, LaserKind kind) {
        if (p1.equals(p2)) {
            return null;
        }
        double iSize = p2.x - p1.x;
        double jSize = p2.y - p1.y;
        double kSize = p2.z - p1.z;
        double i = p1.x;
        double j = p1.y;
        double k = p1.z;
        if (iSize != 0.0) {
            i += 0.5;
            j += 0.45;
            k += 0.45;
            jSize = 0.1;
            kSize = 0.1;
        } else if (jSize != 0.0) {
            i += 0.45;
            j += 0.5;
            k += 0.45;
            iSize = 0.1;
            kSize = 0.1;
        } else if (kSize != 0.0) {
            i += 0.45;
            j += 0.45;
            k += 0.5;
            iSize = 0.1;
            jSize = 0.1;
        }
        EntityBlock block = CoreProxy.proxy.newEntityBlock(world, i, j, k, iSize, jSize, kSize, kind);
        block.setBrightness(210);
        world.spawnEntityInWorld((Entity)block);
        return block;
    }

    public static EntityBlock[] createLaserBox(World world, double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, LaserKind kind) {
        EntityBlock[] lasers = new EntityBlock[12];
        Position[] p = new Position[]{new Position(xMin, yMin, zMin), new Position(xMax, yMin, zMin), new Position(xMin, yMax, zMin), new Position(xMax, yMax, zMin), new Position(xMin, yMin, zMax), new Position(xMax, yMin, zMax), new Position(xMin, yMax, zMax), new Position(xMax, yMax, zMax)};
        lasers[0] = Utils.createLaser(world, p[0], p[1], kind);
        lasers[1] = Utils.createLaser(world, p[0], p[2], kind);
        lasers[2] = Utils.createLaser(world, p[2], p[3], kind);
        lasers[3] = Utils.createLaser(world, p[1], p[3], kind);
        lasers[4] = Utils.createLaser(world, p[4], p[5], kind);
        lasers[5] = Utils.createLaser(world, p[4], p[6], kind);
        lasers[6] = Utils.createLaser(world, p[5], p[7], kind);
        lasers[7] = Utils.createLaser(world, p[6], p[7], kind);
        lasers[8] = Utils.createLaser(world, p[0], p[4], kind);
        lasers[9] = Utils.createLaser(world, p[1], p[5], kind);
        lasers[10] = Utils.createLaser(world, p[2], p[6], kind);
        lasers[11] = Utils.createLaser(world, p[3], p[7], kind);
        return lasers;
    }

    public static LaserData[] createLaserDataBox(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        LaserData[] lasers = new LaserData[12];
        Position[] p = new Position[]{new Position(xMin, yMin, zMin), new Position(xMax, yMin, zMin), new Position(xMin, yMax, zMin), new Position(xMax, yMax, zMin), new Position(xMin, yMin, zMax), new Position(xMax, yMin, zMax), new Position(xMin, yMax, zMax), new Position(xMax, yMax, zMax)};
        lasers[0] = new LaserData(p[0], p[1]);
        lasers[1] = new LaserData(p[0], p[2]);
        lasers[2] = new LaserData(p[2], p[3]);
        lasers[3] = new LaserData(p[1], p[3]);
        lasers[4] = new LaserData(p[4], p[5]);
        lasers[5] = new LaserData(p[4], p[6]);
        lasers[6] = new LaserData(p[5], p[7]);
        lasers[7] = new LaserData(p[6], p[7]);
        lasers[8] = new LaserData(p[0], p[4]);
        lasers[9] = new LaserData(p[1], p[5]);
        lasers[10] = new LaserData(p[2], p[6]);
        lasers[11] = new LaserData(p[3], p[7]);
        return lasers;
    }

    public static void preDestroyBlock(World world, int i, int j, int k) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof IInventory && !world.isRemote && (!(tile instanceof IDropControlInventory) || ((IDropControlInventory)tile).doDrop())) {
            InvUtils.dropItems(world, (IInventory)tile, i, j, k);
            InvUtils.wipeInventory((IInventory)tile);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).destroy();
        }
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            return true;
        }
        return !player.addedToChunk;
    }

    public static boolean checkPipesConnections(TileEntity tile1, TileEntity tile2) {
        if (tile1 == null || tile2 == null) {
            return false;
        }
        if (!(tile1 instanceof IPipeTile) && !(tile2 instanceof IPipeTile)) {
            return false;
        }
        ForgeDirection o = ForgeDirection.UNKNOWN;
        if (tile1.xCoord - 1 == tile2.xCoord) {
            o = ForgeDirection.WEST;
        } else if (tile1.xCoord + 1 == tile2.xCoord) {
            o = ForgeDirection.EAST;
        } else if (tile1.yCoord - 1 == tile2.yCoord) {
            o = ForgeDirection.DOWN;
        } else if (tile1.yCoord + 1 == tile2.yCoord) {
            o = ForgeDirection.UP;
        } else if (tile1.zCoord - 1 == tile2.zCoord) {
            o = ForgeDirection.NORTH;
        } else if (tile1.zCoord + 1 == tile2.zCoord) {
            o = ForgeDirection.SOUTH;
        }
        if (tile1 instanceof IPipeTile && !((IPipeTile)tile1).isPipeConnected(o)) {
            return false;
        }
        return !(tile2 instanceof IPipeTile) || ((IPipeTile)tile2).isPipeConnected(o.getOpposite());
    }

    public static boolean checkLegacyPipesConnections(IBlockAccess blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        Block b1 = blockAccess.getBlock(x1, y1, z1);
        Block b2 = blockAccess.getBlock(x2, y2, z2);
        if (!(b1 instanceof IFramePipeConnection) && !(b2 instanceof IFramePipeConnection)) {
            return false;
        }
        if (b1 instanceof IFramePipeConnection && !((IFramePipeConnection)b1).isPipeConnected(blockAccess, x1, y1, z1, x2, y2, z2)) {
            return false;
        }
        return !(b2 instanceof IFramePipeConnection) || ((IFramePipeConnection)b2).isPipeConnected(blockAccess, x2, y2, z2, x1, y1, z1);
    }

    public static int[] createSlotArray(int first, int count) {
        int[] slots = new int[count];
        for (int k = first; k < first + count; ++k) {
            slots[k - first] = k;
        }
        return slots;
    }

    public static void writeUTF(ByteBuf data, String str) {
        try {
            if (str == null) {
                data.writeInt(0);
                return;
            }
            byte[] b = str.getBytes("UTF-8");
            data.writeInt(b.length);
            data.writeBytes(b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            data.writeInt(0);
        }
    }

    public static String readUTF(ByteBuf data) {
        try {
            int len = data.readInt();
            if (len == 0) {
                return "";
            }
            byte[] b = new byte[len];
            data.readBytes(b);
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBT(ByteBuf data, NBTTagCompound nbt) {
        try {
            byte[] compressed = CompressedStreamTools.compress((NBTTagCompound)nbt);
            data.writeInt(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound readNBT(ByteBuf data) {
        try {
            int length = data.readInt();
            byte[] compressed = new byte[length];
            data.readBytes(compressed);
            return CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStack(ByteBuf data, ItemStack stack) {
        if (stack == null || stack.getItem() == null || stack.stackSize < 0) {
            data.writeByte(0);
        } else {
            data.writeByte(MathUtils.clamp(stack.stackSize + 1, 0, 64) & 0x7F | (stack.hasTagCompound() ? 128 : 0));
            data.writeShort(Item.getIdFromItem((Item)stack.getItem()));
            data.writeShort(stack.getItemDamage());
            if (stack.hasTagCompound()) {
                Utils.writeNBT(data, stack.getTagCompound());
            }
        }
    }

    public static ItemStack readStack(ByteBuf data) {
        short flags = data.readUnsignedByte();
        if (flags == 0) {
            return null;
        }
        boolean hasCompound = (flags & 0x80) != 0;
        int stackSize = (flags & 0x7F) - 1;
        int itemId = data.readUnsignedShort();
        short itemDamage = data.readShort();
        ItemStack stack = new ItemStack(Item.getItemById((int)itemId), stackSize, (int)itemDamage);
        if (hasCompound) {
            stack.setTagCompound(Utils.readNBT(data));
        }
        return stack;
    }

    public static void writeByteArray(ByteBuf stream, byte[] data) {
        stream.writeInt(data.length);
        stream.writeBytes(data);
    }

    public static byte[] readByteArray(ByteBuf stream) {
        byte[] data = new byte[stream.readInt()];
        stream.readBytes(data, 0, data.length);
        return data;
    }

    public static FMLProxyPacket toPacket(BuildCraftPacket packet, int discriminator) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte((int)((byte)discriminator));
        packet.writeData(buf);
        return new FMLProxyPacket(buf, "BC-CORE");
    }
}

