/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils.concurrency;

import buildcraft.core.utils.concurrency.IIterableAlgorithm;
import java.util.Date;

public class IterableAlgorithmRunner
extends Thread {
    private IIterableAlgorithm pathFinding;
    private boolean stop = false;
    private int maxIterations;
    private boolean done = false;

    public IterableAlgorithmRunner(IIterableAlgorithm iPathFinding, int iMaxIterations) {
        super("Path Finding");
        this.pathFinding = iPathFinding;
        this.maxIterations = iMaxIterations;
    }

    public IterableAlgorithmRunner(IIterableAlgorithm iPathFinding) {
        this(iPathFinding, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            for (int i = 0; i < this.maxIterations && !this.isTerminated(); ++i) {
                if (this.pathFinding.isDone()) {
                    break;
                }
                long startTime = new Date().getTime();
                long elapsedtime = 0L;
                this.pathFinding.iterate();
                elapsedtime = new Date().getTime() - startTime;
                double timeToWait = (double)elapsedtime * 1.5;
                IterableAlgorithmRunner.sleep((long)timeToWait);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.done = true;
        }
    }

    public synchronized void terminate() {
        this.stop = true;
    }

    public synchronized boolean isTerminated() {
        return this.stop;
    }

    public synchronized boolean isDone() {
        return this.done;
    }
}

