/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.utils.concurrency;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IZone;
import buildcraft.core.utils.IBlockFilter;
import buildcraft.core.utils.concurrency.IIterableAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.world.World;

public class PathFinding
implements IIterableAlgorithm {
    public static int PATH_ITERATIONS = 1000;
    private World world;
    private BlockIndex start;
    private BlockIndex end;
    private IBlockFilter pathFound;
    private IZone zone;
    private double maxDistanceToEnd = 0.0;
    private float maxTotalDistance = 0.0f;
    private HashMap<BlockIndex, Node> openList = new HashMap();
    private HashMap<BlockIndex, Node> closedList = new HashMap();
    private Node nextIteration;
    private LinkedList<BlockIndex> result;
    private boolean endReached = false;

    public PathFinding(World iWorld, BlockIndex iStart, BlockIndex iEnd) {
        this.world = iWorld;
        this.start = iStart;
        this.end = iEnd;
        Node startNode = new Node();
        startNode.parent = null;
        startNode.movementCost = 0.0;
        startNode.destinationCost = PathFinding.distance(this.start, this.end);
        startNode.totalWeight = startNode.movementCost + startNode.destinationCost;
        startNode.index = iStart;
        this.openList.put(this.start, startNode);
        this.nextIteration = startNode;
    }

    public PathFinding(World iWorld, BlockIndex iStart, BlockIndex iEnd, double iMaxDistanceToEnd) {
        this(iWorld, iStart, iEnd);
        this.maxDistanceToEnd = iMaxDistanceToEnd;
    }

    public PathFinding(World iWorld, BlockIndex iStart, BlockIndex iEnd, double iMaxDistanceToEnd, float iMaxTotalDistance) {
        this(iWorld, iStart, iEnd, iMaxDistanceToEnd);
        this.maxTotalDistance = iMaxTotalDistance;
    }

    @Override
    public void iterate() {
        this.iterate(PATH_ITERATIONS);
    }

    public void iterate(int itNumber) {
        for (int i = 0; i < itNumber; ++i) {
            if (this.nextIteration == null) {
                return;
            }
            if (this.endReached) {
                this.result = new LinkedList();
                while (this.nextIteration != null) {
                    this.result.addFirst(this.nextIteration.index);
                    this.nextIteration = this.nextIteration.parent;
                }
                return;
            }
            this.nextIteration = this.iterate(this.nextIteration);
        }
    }

    @Override
    public boolean isDone() {
        return this.nextIteration == null;
    }

    public LinkedList<BlockIndex> getResult() {
        if (this.result != null) {
            return this.result;
        }
        return new LinkedList<BlockIndex>();
    }

    private Node iterate(Node from) {
        this.openList.remove(from.index);
        this.closedList.put(from.index, from);
        ArrayList<Node> nodes = new ArrayList<Node>();
        byte[][][] resultMoves = this.movements(from);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (resultMoves[dx + 1][dy + 1][dz + 1] == 0) continue;
                    int x = from.index.x + dx;
                    int y = from.index.y + dy;
                    int z = from.index.z + dz;
                    Node nextNode = new Node();
                    nextNode.parent = from;
                    nextNode.index = new BlockIndex(x, y, z);
                    if (resultMoves[dx + 1][dy + 1][dz + 1] == 2) {
                        this.endReached = true;
                        return nextNode;
                    }
                    nextNode.movementCost = from.movementCost + PathFinding.distance(nextNode.index, from.index);
                    nextNode.destinationCost = this.end != null ? PathFinding.distance(nextNode.index, this.end) : (this.zone != null ? (this.zone.contains(x, y, z) ? 0.0 : this.zone.distanceTo(nextNode.index)) : 0.0);
                    nextNode.totalWeight = nextNode.movementCost + nextNode.destinationCost;
                    if (this.maxTotalDistance > 0.0f && nextNode.totalWeight > (double)this.maxTotalDistance) {
                        if (this.closedList.containsKey(nextNode.index)) continue;
                        this.closedList.put(nextNode.index, nextNode);
                        continue;
                    }
                    if (this.closedList.containsKey(nextNode.index)) continue;
                    if (this.openList.containsKey(nextNode.index)) {
                        Node tentative = this.openList.get(nextNode.index);
                        if (tentative.movementCost < nextNode.movementCost) {
                            nextNode = tentative;
                        } else {
                            this.openList.put(nextNode.index, nextNode);
                        }
                    } else {
                        this.openList.put(nextNode.index, nextNode);
                    }
                    nodes.add(nextNode);
                }
            }
        }
        nodes.addAll(this.openList.values());
        return this.findSmallerWeight(nodes);
    }

    private Node findSmallerWeight(Collection<Node> collection) {
        Node found = null;
        for (Node n : collection) {
            if (found == null) {
                found = n;
                continue;
            }
            if (!(n.totalWeight < found.totalWeight)) continue;
            found = n;
        }
        return found;
    }

    private static double distance(BlockIndex i1, BlockIndex i2) {
        double dx = (double)i1.x - (double)i2.x;
        double dy = (double)i1.y - (double)i2.y;
        double dz = (double)i1.z - (double)i2.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean endReached(int x, int y, int z) {
        if (this.zone != null && !this.zone.contains(x, y, z)) {
            return false;
        }
        if (this.pathFound != null) {
            return this.pathFound.matches(this.world, x, y, z);
        }
        if (this.maxDistanceToEnd == 0.0) {
            if (this.end.x != x) return false;
            if (this.end.y != y) return false;
            if (this.end.z != z) return false;
            return true;
        }
        if (!BuildCraftAPI.isSoftBlock(this.world, x, y, z)) return false;
        BlockIndex blockIndex = new BlockIndex(x, y, z);
        if (!(PathFinding.distance(blockIndex, this.end) <= this.maxDistanceToEnd)) return false;
        return true;
    }

    private byte[][][] movements(Node from) {
        int j;
        int i;
        byte[][][] resultMoves = new byte[3][3][3];
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    int x = from.index.x + dx;
                    int y = from.index.y + dy;
                    int z = from.index.z + dz;
                    resultMoves[dx + 1][dy + 1][dz + 1] = this.endReached(x, y, z) ? 2 : (!BuildCraftAPI.isSoftBlock(this.world, x, y, z) ? 0 : 1);
                }
            }
        }
        resultMoves[1][1][1] = 0;
        if (resultMoves[0][1][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[0][i][j] = 0;
                }
            }
        }
        if (resultMoves[2][1][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[2][i][j] = 0;
                }
            }
        }
        if (resultMoves[1][0][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][0][j] = 0;
                }
            }
        }
        if (resultMoves[1][2][1] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][2][j] = 0;
                }
            }
        }
        if (resultMoves[1][1][0] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][j][0] = 0;
                }
            }
        }
        if (resultMoves[1][1][2] == 0) {
            for (i = 0; i <= 2; ++i) {
                for (j = 0; j <= 2; ++j) {
                    resultMoves[i][j][2] = 0;
                }
            }
        }
        if (resultMoves[0][0][1] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[0][0][2] = 0;
        }
        if (resultMoves[0][2][1] == 0) {
            resultMoves[0][2][0] = 0;
            resultMoves[0][2][2] = 0;
        }
        if (resultMoves[2][0][1] == 0) {
            resultMoves[2][0][0] = 0;
            resultMoves[2][0][2] = 0;
        }
        if (resultMoves[2][2][1] == 0) {
            resultMoves[2][2][0] = 0;
            resultMoves[2][2][2] = 0;
        }
        if (resultMoves[0][1][0] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[0][2][0] = 0;
        }
        if (resultMoves[0][1][2] == 0) {
            resultMoves[0][0][2] = 0;
            resultMoves[0][2][2] = 0;
        }
        if (resultMoves[2][1][0] == 0) {
            resultMoves[2][0][0] = 0;
            resultMoves[2][2][0] = 0;
        }
        if (resultMoves[2][1][2] == 0) {
            resultMoves[2][0][2] = 0;
            resultMoves[2][2][2] = 0;
        }
        if (resultMoves[1][0][0] == 0) {
            resultMoves[0][0][0] = 0;
            resultMoves[2][0][0] = 0;
        }
        if (resultMoves[1][0][2] == 0) {
            resultMoves[0][0][2] = 0;
            resultMoves[2][0][2] = 0;
        }
        if (resultMoves[1][2][0] == 0) {
            resultMoves[0][2][0] = 0;
            resultMoves[2][2][0] = 0;
        }
        if (resultMoves[1][2][2] == 0) {
            resultMoves[0][2][2] = 0;
            resultMoves[2][2][2] = 0;
        }
        return resultMoves;
    }

    private static class Node {
        public Node parent;
        public double movementCost;
        public double destinationCost;
        public double totalWeight;
        public BlockIndex index;

        private Node() {
        }
    }
}

