/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.ICustomHighlight;
import buildcraft.core.IItemPipe;
import buildcraft.energy.TileEngine;
import buildcraft.energy.TileEngineCreative;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineStone;
import buildcraft.energy.TileEngineWood;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEngine
extends BlockBuildCraft
implements ICustomHighlight {
    private static final AxisAlignedBB[][] boxes = new AxisAlignedBB[][]{{AxisAlignedBB.getBoundingBox((double)0.0, (double)0.5, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)1.0, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.5)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5), AxisAlignedBB.getBoundingBox((double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75, (double)1.0)}, {AxisAlignedBB.getBoundingBox((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.0, (double)0.25, (double)0.25, (double)0.5, (double)0.75, (double)0.75)}, {AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), AxisAlignedBB.getBoundingBox((double)0.5, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75)}};
    private static IIcon woodTexture;
    private static IIcon stoneTexture;
    private static IIcon ironTexture;

    public BlockEngine() {
        super(Material.iron);
        this.setBlockName("engineBlock");
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        woodTexture = par1IconRegister.registerIcon("buildcraft:engineWoodBottom");
        stoneTexture = par1IconRegister.registerIcon("buildcraft:engineStoneBottom");
        ironTexture = par1IconRegister.registerIcon("buildcraft:engineIronBottom");
    }

    public int getRenderType() {
        return BuildCraftCore.blockByEntityModel;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new TileEngineWood();
            }
            case 1: {
                return new TileEngineStone();
            }
            case 2: {
                return new TileEngineIron();
            }
            case 3: {
                return new TileEngineCreative();
            }
        }
        return new TileEngineWood();
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).orientation.getOpposite() == side;
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).switchOrientation(false);
        }
        return false;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int side, float par7, float par8, float par9) {
        TileEntity tile = world.getTileEntity(i, j, k);
        BlockInteractionEvent event = new BlockInteractionEvent(player, (Block)this, world.getBlockMetadata(i, j, k));
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IItemPipe) {
            return false;
        }
        if (tile instanceof TileEngine) {
            return ((TileEngine)tile).onBlockActivated(player, ForgeDirection.getOrientation((int)side));
        }
        return false;
    }

    public void addCollisionBoxesToList(World wrd, int x, int y, int z, AxisAlignedBB mask, List list, Entity ent) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            AxisAlignedBB[] aabbs;
            for (AxisAlignedBB aabb : aabbs = boxes[((TileEngine)tile).orientation.ordinal()]) {
                AxisAlignedBB aabbTmp = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z);
                if (!mask.intersectsWith(aabbTmp)) continue;
                list.add(aabbTmp);
            }
        } else {
            super.addCollisionBoxesToList(wrd, x, y, z, mask, list, ent);
        }
    }

    @Override
    public AxisAlignedBB[] getBoxes(World wrd, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            return boxes[((TileEngine)tile).orientation.ordinal()];
        }
        return new AxisAlignedBB[]{AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0)};
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    public MovingObjectPosition collisionRayTrace(World wrd, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEntity tile = wrd.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            AxisAlignedBB[] aabbs = boxes[((TileEngine)tile).orientation.ordinal()];
            MovingObjectPosition closest = null;
            for (AxisAlignedBB aabb : aabbs) {
                MovingObjectPosition mop = aabb.getOffsetBoundingBox((double)x, (double)y, (double)z).calculateIntercept(origin, direction);
                if (mop == null) continue;
                closest = closest != null && mop.hitVec.distanceTo(origin) < closest.hitVec.distanceTo(origin) ? mop : mop;
            }
            if (closest != null) {
                closest.blockX = x;
                closest.blockY = y;
                closest.blockZ = z;
            }
            return closest;
        }
        return super.collisionRayTrace(wrd, x, y, z, origin, direction);
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int par5) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            engine.orientation = ForgeDirection.UP;
            if (!engine.isOrientationValid()) {
                engine.switchOrientation(true);
            }
        }
    }

    public int damageDropped(int i) {
        return i;
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (!(tile instanceof TileEngine)) {
            return;
        }
        if (((TileEngine)tile).getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
            for (int f = 0; f < 16; ++f) {
                world.spawnParticle("smoke", (double)((float)i + 0.4f + random.nextFloat() * 0.2f), (double)((float)j + random.nextFloat() * 0.5f), (double)((float)k + 0.4f + random.nextFloat() * 0.2f), (double)(random.nextFloat() * 0.04f - 0.02f), (double)(random.nextFloat() * 0.05f + 0.02f), (double)(random.nextFloat() * 0.04f - 0.02f));
            }
        } else if (((TileEngine)tile).isBurning()) {
            float f = (float)i + 0.5f;
            float f1 = (float)j + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)k + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.spawnParticle("reddust", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            world.spawnParticle("reddust", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        }
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
        itemList.add(new ItemStack((Block)this, 1, 2));
        itemList.add(new ItemStack((Block)this, 1, 3));
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEngine) {
            ((TileEngine)tile).onNeighborUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        switch (meta) {
            case 0: {
                return woodTexture;
            }
            case 1: {
                return stoneTexture;
            }
            case 2: {
                return ironTexture;
            }
        }
        return null;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return null;
    }
}

