/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.energy.TileEngine;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class SchematicEngine
extends SchematicTile {
    @Override
    public void rotateLeft(IBuilderContext context) {
        int o = this.tileNBT.getInteger("orientation");
        o = ForgeDirection.values()[o].getRotation(ForgeDirection.UP).ordinal();
        this.tileNBT.setInteger("orientation", o);
    }

    @Override
    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        TileEngine engine = (TileEngine)context.world().getTileEntity(x, y, z);
        this.tileNBT.setInteger("orientation", engine.orientation.ordinal());
        this.tileNBT.removeTag("progress");
        this.tileNBT.removeTag("energy");
        this.tileNBT.removeTag("heat");
        this.tileNBT.removeTag("tankFuel");
        this.tileNBT.removeTag("tankCoolant");
    }

    @Override
    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        TileEngine engine = (TileEngine)context.world().getTileEntity(x, y, z);
        engine.orientation = ForgeDirection.getOrientation((int)this.tileNBT.getInteger("orientation"));
        engine.sendNetworkUpdate();
    }

    @Override
    public void postProcessing(IBuilderContext context, int x, int y, int z) {
        TileEngine engine = (TileEngine)context.world().getTileEntity(x, y, z);
        if (engine != null) {
            engine.orientation = ForgeDirection.getOrientation((int)this.tileNBT.getInteger("orientation"));
            engine.sendNetworkUpdate();
            context.world().markBlockForUpdate(x, y, z);
            context.world().notifyBlocksOfNeighborChange(x, y, z, this.block);
        }
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.STANDALONE;
    }
}

