/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import cofh.api.energy.IEnergyHandler;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyReceiver
extends TileBuildCraft
implements IPipeConnection {
    public static LinkedList<TileEnergyReceiver> knownReceivers = new LinkedList();
    public int energyStored = 0;
    private TileBuffer[] tileCache;

    public TileEnergyReceiver() {
        knownReceivers.add(this);
    }

    @Override
    public void invalidate() {
        knownReceivers.remove(this);
    }

    public TileBuffer getTileBuffer(ForgeDirection side) {
        if (this.tileCache == null) {
            this.tileCache = TileBuffer.makeBuffer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
        }
        return this.tileCache[side.ordinal()];
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IEnergyHandler) {
            return ((IEnergyHandler)tile).canConnectEnergy(side.getOpposite());
        }
        return false;
    }

    private void sendPower() {
        for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.getTileBuffer(s).getTile();
            if (!(tile instanceof IEnergyHandler)) continue;
            int energyUsed = ((IEnergyHandler)tile).receiveEnergy(s.getOpposite(), this.energyStored, false);
            this.energyStored -= energyUsed;
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.POWER ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public void updateEntity() {
        this.sendPower();
    }
}

