/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.PowerMode;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineCreative
extends TileEngine {
    private PowerMode powerMode = PowerMode.M2;

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[3];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[3];
    }

    @Override
    public ResourceLocation getTrunkTexture(TileEngine.EnergyStage stage) {
        return TRUNK_TEXTURES[3];
    }

    @Override
    protected TileEngine.EnergyStage computeEnergyStage() {
        return TileEngine.EnergyStage.BLUE;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!this.getWorldObj().isRemote) {
            Item equipped;
            Item item = equipped = player.getCurrentEquippedItem() != null ? player.getCurrentEquippedItem().getItem() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.xCoord, this.yCoord, this.zCoord)) {
                this.powerMode = this.powerMode.getNext();
                this.energy = 0;
                if (!(player instanceof FakePlayer)) {
                    if (BuildCraftCore.hidePowerNumbers) {
                        player.addChatMessage((IChatComponent)new ChatComponentText(String.format(StringUtils.localize("chat.pipe.power.iron.mode.numberless"), StringUtils.localize("chat.pipe.power.iron.level." + this.powerMode.maxPower))));
                    } else {
                        player.addChatMessage((IChatComponent)new ChatComponentText(String.format(StringUtils.localize("chat.pipe.power.iron.mode"), this.powerMode.maxPower)));
                    }
                }
                this.sendNetworkUpdate();
                ((IToolWrench)equipped).wrenchUsed(player, this.xCoord, this.yCoord, this.zCoord);
                return true;
            }
        }
        return !player.isSneaking();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powerMode = PowerMode.fromId(data.getByte("mode"));
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("mode", (byte)this.powerMode.ordinal());
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.powerMode = PowerMode.fromId(stream.readUnsignedByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        stream.writeByte(this.powerMode.ordinal());
    }

    @Override
    public float getPistonSpeed() {
        return 0.02f * (float)(this.powerMode.ordinal() + 1);
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered) {
            this.addEnergy(this.calculateCurrentOutput());
        }
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int maxEnergyReceived() {
        return this.calculateCurrentOutput();
    }

    @Override
    public int maxEnergyExtracted() {
        return this.calculateCurrentOutput();
    }

    @Override
    public int getMaxEnergy() {
        return this.calculateCurrentOutput();
    }

    @Override
    public int calculateCurrentOutput() {
        return this.powerMode.maxPower;
    }
}

