/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.energy.TileEngine;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineWood
extends TileEngine
implements IRedstoneEngine {
    private boolean hasSent = false;

    @Override
    public ResourceLocation getBaseTexture() {
        return BASE_TEXTURES[0];
    }

    @Override
    public ResourceLocation getChamberTexture() {
        return CHAMBER_TEXTURES[0];
    }

    @Override
    public ResourceLocation getTrunkTexture(TileEngine.EnergyStage stage) {
        return super.getTrunkTexture(stage == TileEngine.EnergyStage.RED && (double)this.progress < 0.5 ? TileEngine.EnergyStage.YELLOW : stage);
    }

    @Override
    public int minEnergyReceived() {
        return 0;
    }

    @Override
    public int maxEnergyReceived() {
        return 500;
    }

    @Override
    protected TileEngine.EnergyStage computeEnergyStage() {
        double energyLevel = this.getEnergyLevel();
        if (energyLevel < (double)0.33f) {
            return TileEngine.EnergyStage.BLUE;
        }
        if (energyLevel < (double)0.66f) {
            return TileEngine.EnergyStage.GREEN;
        }
        if (energyLevel < 0.75) {
            return TileEngine.EnergyStage.YELLOW;
        }
        return TileEngine.EnergyStage.RED;
    }

    @Override
    public float getPistonSpeed() {
        if (!this.worldObj.isRemote) {
            return Math.max(0.08f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case GREEN: {
                return 0.02f;
            }
            case YELLOW: {
                return 0.04f;
            }
            case RED: {
                return 0.08f;
            }
        }
        return 0.01f;
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered && this.worldObj.getTotalWorldTime() % 16L == 0L) {
            this.addEnergy(10);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getMaxEnergy() {
        return 1000;
    }

    @Override
    public int calculateCurrentOutput() {
        return 10;
    }

    @Override
    public int maxEnergyExtracted() {
        return 10;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    @Override
    protected void sendPower() {
        if (this.progressPart == 2 && !this.hasSent) {
            this.hasSent = true;
            TileEntity tile = this.getTile(this.orientation);
            if (tile instanceof IRedstoneEngineReceiver && ((IRedstoneEngineReceiver)tile).canConnectRedstoneEngine(this.orientation.getOpposite())) {
                super.sendPower();
            } else {
                this.energy = 0;
            }
        } else if (this.progressPart != 2) {
            this.hasSent = false;
        }
    }
}

