/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.BuildCraftCore;
import buildcraft.core.CoreIconProvider;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.GuiBuildCraft;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;

public abstract class GuiEngine
extends GuiBuildCraft {
    private static final ResourceLocation ITEM_TEXTURE = TextureMap.locationItemsTexture;

    public GuiEngine(BuildCraftContainer container, IInventory inventory, ResourceLocation texture) {
        super(container, inventory, texture);
    }

    @Override
    protected void initLedgers(IInventory inventory) {
        super.initLedgers(inventory);
        if (!BuildCraftCore.hidePowerNumbers) {
            this.ledgerManager.add(new EngineLedger((TileEngine)this.tile));
        }
    }

    protected class EngineLedger
    extends GuiBuildCraft.Ledger {
        TileEngine engine;
        int headerColour = 14797103;
        int subheaderColour = 11186104;
        int textColour = 0;

        public EngineLedger(TileEngine engine) {
            this.engine = engine;
            this.maxHeight = 94;
            this.overlayColor = 13921311;
        }

        @Override
        public void draw(int x, int y) {
            this.drawBackground(x, y);
            Minecraft.getMinecraft().renderEngine.bindTexture(ITEM_TEXTURE);
            this.drawIcon(BuildCraftCore.iconProvider.getIcon(CoreIconProvider.ENERGY), x + 3, y + 4);
            if (!this.isFullyOpened()) {
                return;
            }
            GuiEngine.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.energy"), x + 22, y + 8, this.headerColour);
            GuiEngine.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.currentOutput") + ":", x + 22, y + 20, this.subheaderColour);
            GuiEngine.this.fontRendererObj.drawString(String.format("%d RF/t", this.engine.currentOutput), x + 22, y + 32, this.textColour);
            GuiEngine.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.stored") + ":", x + 22, y + 44, this.subheaderColour);
            GuiEngine.this.fontRendererObj.drawString(String.format("%d RF", this.engine.getEnergyStored()), x + 22, y + 56, this.textColour);
            GuiEngine.this.fontRendererObj.drawStringWithShadow(StringUtils.localize("gui.heat") + ":", x + 22, y + 68, this.subheaderColour);
            GuiEngine.this.fontRendererObj.drawString(String.format("%.2f \u00b0C", this.engine.getCurrentHeatValue()), x + 22, y + 80, this.textColour);
        }

        @Override
        public String getTooltip() {
            return String.format("%d RF/t", this.engine.currentOutput);
        }
    }
}

