/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.gui;

import buildcraft.core.DefaultProps;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngineStone;
import buildcraft.energy.gui.ContainerEngine;
import buildcraft.energy.gui.GuiEngine;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiStoneEngine
extends GuiEngine {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_GUI + "/steam_engine_gui.png");

    public GuiStoneEngine(InventoryPlayer inventoryplayer, TileEngineStone tileEngine) {
        super(new ContainerEngine(inventoryplayer, tileEngine), tileEngine, TEXTURE);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        super.drawGuiContainerForegroundLayer(par1, par2);
        String title = StringUtils.localize("tile.engineStone.name");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, 0x404040);
        this.fontRendererObj.drawString(StringUtils.localize("gui.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        TileEngineStone engine = (TileEngineStone)this.tile;
        if (engine.getScaledBurnTime(12) > 0) {
            int l = engine.getScaledBurnTime(12);
            this.drawTexturedModalRect(this.guiLeft + 80, this.guiTop + 24 + 12 - l, 176, 12 - l, 14, l + 2);
        }
    }
}

