/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.render;

import buildcraft.BuildCraftCore;
import buildcraft.core.IInventoryRenderer;
import buildcraft.energy.TileEngine;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderEngine
extends TileEntitySpecialRenderer
implements IInventoryRenderer {
    private static final float[] angleMap = new float[6];
    private ModelBase model = new ModelBase(){};
    private ModelRenderer box = new ModelRenderer(this.model, 0, 1);
    private ModelRenderer trunk;
    private ModelRenderer movingBox;
    private ModelRenderer chamber;
    private ResourceLocation baseTexture;
    private ResourceLocation chamberTexture;
    private ResourceLocation trunkTexture;

    public RenderEngine() {
        this.box.addBox(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.box.rotationPointX = 8.0f;
        this.box.rotationPointY = 8.0f;
        this.box.rotationPointZ = 8.0f;
        this.trunk = new ModelRenderer(this.model, 1, 1);
        this.trunk.addBox(-4.0f, -4.0f, -4.0f, 8, 12, 8);
        this.trunk.rotationPointX = 8.0f;
        this.trunk.rotationPointY = 8.0f;
        this.trunk.rotationPointZ = 8.0f;
        this.movingBox = new ModelRenderer(this.model, 0, 1);
        this.movingBox.addBox(-8.0f, -4.0f, -8.0f, 16, 4, 16);
        this.movingBox.rotationPointX = 8.0f;
        this.movingBox.rotationPointY = 8.0f;
        this.movingBox.rotationPointZ = 8.0f;
        this.chamber = new ModelRenderer(this.model, 1, 1);
        this.chamber.addBox(-5.0f, -4.0f, -5.0f, 10, 2, 10);
        this.chamber.rotationPointX = 8.0f;
        this.chamber.rotationPointY = 8.0f;
        this.chamber.rotationPointZ = 8.0f;
    }

    public RenderEngine(ResourceLocation baseTexture, ResourceLocation chamberTexture, ResourceLocation trunkTexture) {
        this();
        this.baseTexture = baseTexture;
        this.chamberTexture = chamberTexture;
        this.trunkTexture = trunkTexture;
        this.field_147501_a = TileEntityRendererDispatcher.instance;
    }

    @Override
    public void inventoryRender(double x, double y, double z, float f, float f1) {
        this.render(0.25f, ForgeDirection.UP, this.baseTexture, this.chamberTexture, this.trunkTexture, x, y, z);
    }

    public void renderTileEntityAt(TileEntity tileentity, double x, double y, double z, float f) {
        TileEngine engine = (TileEngine)tileentity;
        if (engine != null) {
            this.render(engine.progress, engine.orientation, engine.getBaseTexture(), engine.getChamberTexture(), engine.getTrunkTexture(engine.getEnergyStage()), x, y, z);
        }
    }

    private void render(float progress, ForgeDirection orientation, ResourceLocation baseTexture, ResourceLocation chamberTexture, ResourceLocation trunkTexture, double x, double y, double z) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float step = (double)progress > 0.5 ? 7.99f - (progress - 0.5f) * 2.0f * 7.99f : progress * 2.0f * 7.99f;
        float translatefact = step / 16.0f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{orientation.offsetX, orientation.offsetY, orientation.offsetZ};
        switch (orientation) {
            case EAST: 
            case WEST: 
            case DOWN: {
                angle[2] = angleMap[orientation.ordinal()];
                break;
            }
            default: {
                angle[0] = angleMap[orientation.ordinal()];
            }
        }
        this.box.rotateAngleX = angle[0];
        this.box.rotateAngleY = angle[1];
        this.box.rotateAngleZ = angle[2];
        this.trunk.rotateAngleX = angle[0];
        this.trunk.rotateAngleY = angle[1];
        this.trunk.rotateAngleZ = angle[2];
        this.movingBox.rotateAngleX = angle[0];
        this.movingBox.rotateAngleY = angle[1];
        this.movingBox.rotateAngleZ = angle[2];
        this.chamber.rotateAngleX = angle[0];
        this.chamber.rotateAngleY = angle[1];
        this.chamber.rotateAngleZ = angle[2];
        float factor = 0.0625f;
        this.bindTexture(baseTexture);
        this.box.render(factor);
        GL11.glTranslatef((float)(translate[0] * translatefact), (float)(translate[1] * translatefact), (float)(translate[2] * translatefact));
        this.movingBox.render(factor);
        GL11.glTranslatef((float)(-translate[0] * translatefact), (float)(-translate[1] * translatefact), (float)(-translate[2] * translatefact));
        this.bindTexture(chamberTexture);
        float chamberf = 0.125f;
        int chamberc = ((int)step + 4) / 2;
        int i = 0;
        while ((float)i <= step + 2.0f) {
            this.chamber.render(factor);
            GL11.glTranslatef((float)(translate[0] * chamberf), (float)(translate[1] * chamberf), (float)(translate[2] * chamberf));
            i += 2;
        }
        GL11.glTranslatef((float)(-translate[0] * chamberf * (float)chamberc), (float)(-translate[1] * chamberf * (float)chamberc), (float)(-translate[2] * chamberf * (float)chamberc));
        this.bindTexture(trunkTexture);
        this.trunk.render(factor);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    static {
        RenderEngine.angleMap[ForgeDirection.EAST.ordinal()] = -1.5707964f;
        RenderEngine.angleMap[ForgeDirection.WEST.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.UP.ordinal()] = 0.0f;
        RenderEngine.angleMap[ForgeDirection.DOWN.ordinal()] = (float)Math.PI;
        RenderEngine.angleMap[ForgeDirection.SOUTH.ordinal()] = 1.5707964f;
        RenderEngine.angleMap[ForgeDirection.NORTH.ordinal()] = -1.5707964f;
    }
}

