/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.IItemPipe;
import buildcraft.factory.TileAutoWorkbench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockAutoWorkbench
extends BlockBuildCraft {
    IIcon topTexture;
    IIcon sideTexture;

    public BlockAutoWorkbench() {
        super(Material.wood);
        this.setHardness(3.0f);
    }

    public IIcon getIcon(int i, int j) {
        if (i == 1 || i == 0) {
            return this.topTexture;
        }
        return this.sideTexture;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        super.onBlockActivated(world, i, j, k, entityplayer, par6, par7, par8, par9);
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (entityplayer.isSneaking()) {
            return false;
        }
        if (entityplayer.getCurrentEquippedItem() != null && entityplayer.getCurrentEquippedItem().getItem() instanceof IItemPipe) {
            return false;
        }
        if (!world.isRemote) {
            entityplayer.openGui((Object)BuildCraftFactory.instance, 30, world, i, j, k);
        }
        return true;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileAutoWorkbench();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.topTexture = par1IconRegister.registerIcon("buildcraft:autoWorkbench_top");
        this.sideTexture = par1IconRegister.registerIcon("buildcraft:autoWorkbench_side");
    }
}

