/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileFloodGate;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockFloodGate
extends BlockBuildCraft {
    private IIcon textureTop;
    private IIcon textureBottom;
    private IIcon textureSide;

    public BlockFloodGate() {
        super(Material.iron);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileFloodGate();
    }

    public IIcon getIcon(int i, int j) {
        switch (i) {
            case 0: {
                return this.textureBottom;
            }
            case 1: {
                return this.textureTop;
            }
        }
        return this.textureSide;
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        super.breakBlock(world, x, y, z, block, par6);
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileFloodGate) {
            Item equipped;
            TileFloodGate floodGate = (TileFloodGate)tile;
            if (entityplayer.isSneaking()) {
                return false;
            }
            Item item = equipped = entityplayer.getCurrentEquippedItem() != null ? entityplayer.getCurrentEquippedItem().getItem() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(entityplayer, i, j, k)) {
                floodGate.rebuildQueue();
                ((IToolWrench)equipped).wrenchUsed(entityplayer, i, j, k);
                return true;
            }
        }
        return false;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        super.onNeighborBlockChange(world, x, y, z, block);
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileFloodGate) {
            ((TileFloodGate)tile).onNeighborBlockChange(block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.textureTop = par1IconRegister.registerIcon("buildcraft:floodgate_top");
        this.textureBottom = par1IconRegister.registerIcon("buildcraft:floodgate_bottom");
        this.textureSide = par1IconRegister.registerIcon("buildcraft:floodgate_side");
    }
}

