/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.MathUtils;
import buildcraft.core.utils.Utils;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class BlockMiner {
    protected final World world;
    protected final TileEntity owner;
    protected final int x;
    protected final int y;
    protected final int z;
    protected final int minerId;
    private boolean hasMined;
    private boolean hasFailed;
    private int energyRequired;
    private int energyAccepted;

    public BlockMiner(World world, TileEntity owner, int x, int y, int z) {
        this.world = world;
        this.owner = owner;
        this.x = x;
        this.y = y;
        this.z = z;
        this.minerId = world.rand.nextInt();
    }

    public boolean hasMined() {
        return this.hasMined;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public void mineStack(ItemStack stack) {
        stack.stackSize -= Utils.addToRandomInventoryAround(this.owner.getWorldObj(), this.owner.xCoord, this.owner.yCoord, this.owner.zCoord, stack);
        if (stack.stackSize > 0) {
            stack.stackSize -= Utils.addToRandomInjectableAround(this.owner.getWorldObj(), this.owner.xCoord, this.owner.yCoord, this.owner.zCoord, ForgeDirection.UNKNOWN, stack);
        }
        if (stack.stackSize > 0) {
            float f = this.world.rand.nextFloat() * 0.8f + 0.1f;
            float f1 = this.world.rand.nextFloat() * 0.8f + 0.1f;
            float f2 = this.world.rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.owner.getWorldObj(), (double)((float)this.owner.xCoord + f), (double)((float)this.owner.yCoord + f1 + 0.5f), (double)((float)this.owner.zCoord + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.delayBeforeCanPickup = 10;
            float f3 = 0.05f;
            entityitem.motionX = (float)this.world.rand.nextGaussian() * f3;
            entityitem.motionY = (float)this.world.rand.nextGaussian() * f3 + 1.0f;
            entityitem.motionZ = (float)this.world.rand.nextGaussian() * f3;
            this.owner.getWorldObj().spawnEntityInWorld((Entity)entityitem);
        }
    }

    public void invalidate() {
        this.world.destroyBlockInWorldPartially(this.minerId, this.x, this.y, this.z, -1);
    }

    public int acceptEnergy(int offeredAmount) {
        this.energyRequired = BlockUtils.computeBlockBreakEnergy(this.world, this.x, this.y, this.z);
        int usedAmount = MathUtils.clamp(offeredAmount, 0, Math.max(0, this.energyRequired - this.energyAccepted));
        this.energyAccepted += usedAmount;
        if (this.energyAccepted >= this.energyRequired) {
            this.world.destroyBlockInWorldPartially(this.minerId, this.x, this.y, this.z, -1);
            this.hasMined = true;
            Block block = this.world.getBlock(this.x, this.y, this.z);
            int meta = this.world.getBlockMetadata(this.x, this.y, this.z);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.x, this.y, this.z, this.world, block, meta, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.world).get());
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                List<ItemStack> stacks = BlockUtils.getItemStackFromBlock((WorldServer)this.world, this.x, this.y, this.z);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.mineStack(s);
                    }
                }
                this.world.playAuxSFXAtEntity(null, 2001, this.x, this.y, this.z, Block.getIdFromBlock((Block)block) + (meta << 12));
                Utils.preDestroyBlock(this.world, this.x, this.y, this.z);
                this.world.setBlockToAir(this.x, this.y, this.z);
            } else {
                this.hasFailed = true;
            }
        } else {
            this.world.destroyBlockInWorldPartially(this.minerId, this.x, this.y, this.z, MathUtils.clamp((int)Math.floor(this.energyAccepted * 10 / this.energyRequired), 0, 9));
        }
        return usedAmount;
    }
}

