/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileMiningWell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMiningWell
extends BlockBuildCraft {
    IIcon textureFront;
    IIcon textureSides;
    IIcon textureBack;
    IIcon textureTop;

    public BlockMiningWell() {
        super(Material.ground);
        this.setHardness(5.0f);
        this.setResistance(10.0f);
        this.setStepSound(soundTypeStone);
    }

    public IIcon getIcon(int i, int j) {
        if (j == 0 && i == 3) {
            return this.textureFront;
        }
        if (i == 1) {
            return this.textureTop;
        }
        if (i == 0) {
            return this.textureBack;
        }
        if (i == j) {
            return this.textureFront;
        }
        if (j >= 0 && j < 6 && ForgeDirection.values()[j].getOpposite().ordinal() == i) {
            return this.textureBack;
        }
        return this.textureSides;
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.setBlockMetadataWithNotify(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    @Override
    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        super.breakBlock(world, x, y, z, block, meta);
        this.removePipes(world, x, y, z);
    }

    public void removePipes(World world, int x, int y, int z) {
        Block pipe;
        for (int depth = y - 1; depth > 0 && (pipe = world.getBlock(x, depth, z)) == BuildCraftFactory.plainPipeBlock; --depth) {
            world.setBlockToAir(x, depth, z);
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileMiningWell();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.textureFront = par1IconRegister.registerIcon("buildcraft:miningwell_front");
        this.textureSides = par1IconRegister.registerIcon("buildcraft:miningwell_side");
        this.textureBack = par1IconRegister.registerIcon("buildcraft:miningwell_back");
        this.textureTop = par1IconRegister.registerIcon("buildcraft:miningwell_top");
    }
}

