/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.tools.IToolWrench;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.fluids.TankUtils;
import buildcraft.core.utils.Utils;
import buildcraft.factory.TileRefinery;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class BlockRefinery
extends BlockBuildCraft {
    private static IIcon icon;

    public BlockRefinery() {
        super(Material.iron);
        this.setHardness(5.0f);
        this.setCreativeTab(CreativeTabBuildCraft.BLOCKS.get());
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public int getRenderType() {
        return BuildCraftCore.blockByEntityModel;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileRefinery();
    }

    @Override
    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(world, i, j, k, entityliving, stack);
        ForgeDirection orientation = Utils.get2dOrientation(entityliving);
        world.setBlockMetadataWithNotify(i, j, k, orientation.getOpposite().ordinal(), 1);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        int meta = world.getBlockMetadata(x, y, z);
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.SOUTH.ordinal(), 3);
                break;
            }
            case EAST: {
                world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.NORTH.ordinal(), 3);
                break;
            }
            case NORTH: {
                world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.WEST.ordinal(), 3);
                break;
            }
            default: {
                world.setBlockMetadataWithNotify(x, y, z, ForgeDirection.EAST.ordinal(), 3);
            }
        }
        world.markBlockForUpdate(x, y, z);
        return true;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item equipped;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!(tile instanceof TileRefinery)) {
            return false;
        }
        BlockInteractionEvent event = new BlockInteractionEvent(player, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        ItemStack current = player.getCurrentEquippedItem();
        Item item = equipped = current != null ? current.getItem() : null;
        if (player.isSneaking() && equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, x, y, z)) {
            ((TileRefinery)tile).resetFilters();
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        if (current != null && current.getItem() != Items.bucket && (!world.isRemote ? TankUtils.handleRightClick((TileRefinery)tile, ForgeDirection.getOrientation((int)side), player, true, false) : FluidContainerRegistry.isContainer((ItemStack)current))) {
            return true;
        }
        if (!world.isRemote) {
            player.openGui((Object)BuildCraftFactory.instance, 31, world, x, y, z);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        icon = par1IconRegister.registerIcon("buildcraft:refineryBack");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        return icon;
    }
}

