/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.inventory.InvUtils;
import buildcraft.factory.TileTank;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BlockTank
extends BlockBuildCraft {
    private IIcon textureStackedSide;
    private IIcon textureBottomSide;
    private IIcon textureTop;

    public BlockTank() {
        super(Material.glass);
        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.setHardness(0.5f);
        this.setCreativeTab(CreativeTabBuildCraft.BLOCKS.get());
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TileTank();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int par1, int par2) {
        switch (par1) {
            case 0: 
            case 1: {
                return this.textureTop;
            }
        }
        return this.textureBottomSide;
    }

    public IIcon getIcon(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        switch (l) {
            case 0: 
            case 1: {
                return this.textureTop;
            }
        }
        if (iblockaccess.getBlock(i, j - 1, k) == this) {
            return this.textureStackedSide;
        }
        return this.textureBottomSide;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        TileEntity tile;
        ItemStack current = entityplayer.inventory.getCurrentItem();
        BlockInteractionEvent event = new BlockInteractionEvent(entityplayer, (Block)this);
        FMLCommonHandler.instance().bus().post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (current != null && (tile = world.getTileEntity(i, j, k)) instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            if (FluidContainerRegistry.isContainer((ItemStack)current)) {
                ItemStack filled;
                FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
                if (liquid != null) {
                    int qty = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (qty != 0 && !BuildCraftCore.debugWorldgen && !entityplayer.capabilities.isCreativeMode) {
                        if (current.stackSize > 1) {
                            if (!entityplayer.inventory.addItemStackToInventory(FluidContainerRegistry.drainFluidContainer((ItemStack)current))) {
                                entityplayer.dropPlayerItemWithRandomChoice(FluidContainerRegistry.drainFluidContainer((ItemStack)current), false);
                            }
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(current));
                        } else {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, FluidContainerRegistry.drainFluidContainer((ItemStack)current));
                        }
                    }
                    return true;
                }
                FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
                if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!BuildCraftCore.debugWorldgen && !entityplayer.capabilities.isCreativeMode) {
                        if (current.stackSize > 1) {
                            if (!entityplayer.inventory.addItemStackToInventory(filled)) {
                                return false;
                            }
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(current));
                        } else {
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, InvUtils.consumeItem(current));
                            entityplayer.inventory.setInventorySlotContents(entityplayer.inventory.currentItem, filled);
                        }
                    }
                    tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                    return true;
                }
            } else if (current.getItem() instanceof IFluidContainerItem) {
                if (current.stackSize != 1) {
                    return false;
                }
                if (!world.isRemote) {
                    boolean mustFill;
                    IFluidContainerItem container = (IFluidContainerItem)current.getItem();
                    FluidStack liquid = container.getFluid(current);
                    FluidStack tankLiquid = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
                    boolean mustDrain = liquid == null || liquid.amount == 0;
                    boolean bl = mustFill = tankLiquid == null || tankLiquid.amount == 0;
                    if (!mustDrain || !mustFill) {
                        if (mustDrain || !entityplayer.isSneaking()) {
                            liquid = tank.drain(ForgeDirection.UNKNOWN, 1000, false);
                            int qtyToFill = container.fill(current, liquid, true);
                            tank.drain(ForgeDirection.UNKNOWN, qtyToFill, true);
                        } else if ((mustFill || entityplayer.isSneaking()) && liquid != null && liquid.amount > 0) {
                            int qty = tank.fill(ForgeDirection.UNKNOWN, liquid, false);
                            tank.fill(ForgeDirection.UNKNOWN, container.drain(current, qty, true), true);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (side <= 1) {
            return world.getBlock(x, y, z) != this;
        }
        return super.shouldSideBeRendered(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.textureStackedSide = par1IconRegister.registerIcon("buildcraft:tank_stacked_side");
        this.textureBottomSide = par1IconRegister.registerIcon("buildcraft:tank_bottom_side");
        this.textureTop = par1IconRegister.registerIcon("buildcraft:tank_top");
    }

    @Override
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            return tank.getFluidLightLevel();
        }
        return super.getLightValue(world, x, y, z);
    }
}

