/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.core.EntityBlock;
import buildcraft.factory.FactoryProxy;
import buildcraft.factory.TileQuarry;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EntityMechanicalArm
extends Entity {
    protected TileQuarry parent;
    private double armSizeX;
    private double armSizeZ;
    private double xRoot;
    private double yRoot;
    private double zRoot;
    private boolean inProgressionXZ = false;
    private boolean inProgressionY = false;
    private int headX;
    private int headY;
    private int headZ;
    private EntityBlock xArm;
    private EntityBlock yArm;
    private EntityBlock zArm;
    private EntityBlock head;

    public EntityMechanicalArm(World world) {
        super(world);
        this.makeParts(world);
        this.noClip = true;
    }

    public EntityMechanicalArm(World world, double x, double y, double z, double width, double height, TileQuarry parent) {
        this(world);
        this.setPositionAndRotation(parent.xCoord, parent.yCoord, parent.zCoord, 0.0f, 0.0f);
        this.xRoot = x;
        this.yRoot = y;
        this.zRoot = z;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.setArmSize(width, height);
        this.setHead(x, y - 2.0, z);
        this.parent = parent;
        parent.setArm(this);
        this.updatePosition();
    }

    void setHead(double x, double y, double z) {
        this.headX = (int)(x * 32.0);
        this.headY = (int)(y * 32.0);
        this.headZ = (int)(z * 32.0);
    }

    private void setArmSize(double x, double z) {
        this.armSizeX = x;
        this.xArm.iSize = x;
        this.armSizeZ = z;
        this.zArm.kSize = z;
        this.updatePosition();
    }

    private void makeParts(World world) {
        this.xArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
        this.yArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
        this.zArm = FactoryProxy.proxy.newDrill(world, 0.0, 0.0, 0.0, 0.5, 0.5, 1.0);
        this.head = FactoryProxy.proxy.newDrillHead(world, 0.0, 0.0, 0.0, 0.2, 1.0, 0.2);
        this.head.shadowSize = 1.0f;
        world.spawnEntityInWorld((Entity)this.xArm);
        world.spawnEntityInWorld((Entity)this.yArm);
        world.spawnEntityInWorld((Entity)this.zArm);
        world.spawnEntityInWorld((Entity)this.head);
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xRoot = nbttagcompound.getDouble("xRoot");
        this.yRoot = nbttagcompound.getDouble("yRoot");
        this.zRoot = nbttagcompound.getDouble("zRoot");
        this.armSizeX = nbttagcompound.getDouble("armSizeX");
        this.armSizeZ = nbttagcompound.getDouble("armSizeZ");
        this.setArmSize(this.armSizeX, this.armSizeZ);
        this.updatePosition();
    }

    private void findAndJoinQuarry() {
        TileEntity te = this.worldObj.getTileEntity((int)this.posX, (int)this.posY, (int)this.posZ);
        if (te != null && te instanceof TileQuarry) {
            this.parent = (TileQuarry)te;
            this.parent.setArm(this);
        } else {
            this.setDead();
        }
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setDouble("xRoot", this.xRoot);
        nbttagcompound.setDouble("yRoot", this.yRoot);
        nbttagcompound.setDouble("zRoot", this.zRoot);
        nbttagcompound.setDouble("armSizeX", this.armSizeX);
        nbttagcompound.setDouble("armSizeZ", this.armSizeZ);
    }

    public void onUpdate() {
        super.onUpdate();
        this.updatePosition();
        if (this.parent == null) {
            this.findAndJoinQuarry();
        }
        if (this.parent == null) {
            this.setDead();
            return;
        }
    }

    public void updatePosition() {
        double[] headT = this.getHead();
        this.xArm.setPosition(this.xRoot, this.yRoot, headT[2] + 0.25);
        this.yArm.jSize = this.yRoot - headT[1] - 1.0;
        this.yArm.setPosition(headT[0] + 0.25, headT[1] + 1.0, headT[2] + 0.25);
        this.zArm.setPosition(headT[0] + 0.25, this.yRoot, this.zRoot);
        this.head.setPosition(headT[0] + 0.4, headT[1], headT[2] + 0.4);
    }

    public void setDead() {
        if (this.worldObj != null && this.worldObj.isRemote) {
            this.xArm.setDead();
            this.yArm.setDead();
            this.zArm.setDead();
            this.head.setDead();
        }
        super.setDead();
    }

    private double[] getHead() {
        return new double[]{(double)this.headX / 32.0, (double)this.headY / 32.0, (double)this.headZ / 32.0};
    }
}

