/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.IInvSlot;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.InventoryConcatenator;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.CraftingHelper;
import buildcraft.core.utils.Utils;
import java.lang.ref.WeakReference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAutoWorkbench
extends TileBuildCraft
implements ISidedInventory {
    public static final int SLOT_RESULT = 0;
    public static final int CRAFT_TIME = 256;
    public static final int UPDATE_TIME = 16;
    private static final int[] SLOTS = Utils.createSlotArray(0, 10);
    public InventoryCrafting craftMatrix = new LocalInventoryCrafting();
    public boolean useLast;
    public int progress;
    private boolean isJammed;
    private boolean needsBalancing;
    private SimpleInventory resultInv = new SimpleInventory(1, "Auto Workbench", 64);
    private IInventory inv = InventoryConcatenator.make().add(this.resultInv).add((IInventory)this.craftMatrix);
    private SlotCrafting craftSlot;
    private InventoryCraftResult craftResult = new InventoryCraftResult();
    private int update = Utils.RANDOM.nextInt();

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord);
    }

    public void markDirty() {
        super.markDirty();
        this.inv.markDirty();
    }

    public int getSizeInventory() {
        return 10;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int count) {
        return this.inv.decrStackSize(slot, count);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.inv.getStackInSlotOnClosing(slot);
    }

    public String getInventoryName() {
        return "";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.resultInv.readFromNBT(data);
        InvUtils.readInvFromNBT((IInventory)this.craftMatrix, "matrix", data);
        if (data.hasKey("stackList")) {
            ItemStack[] stacks = new ItemStack[9];
            InvUtils.readStacksFromNBT(data, "stackList", stacks);
            for (int i = 0; i < 9; ++i) {
                this.craftMatrix.setInventorySlotContents(i, stacks[i]);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.resultInv.writeToNBT(data);
        InvUtils.writeInvToNBT((IInventory)this.craftMatrix, "matrix", data);
    }

    public ItemStack findRecipeOutput() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            return null;
        }
        ItemStack result = recipe.getCraftingResult(this.craftMatrix);
        if (result != null) {
            result = result.copy();
        }
        return result;
    }

    public IRecipe findRecipe() {
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            if (!stack.isStackable()) {
                return null;
            }
            if (!stack.getItem().hasContainerItem(stack)) continue;
            return null;
        }
        return CraftingHelper.findMatchingRecipe(this.craftMatrix, this.worldObj);
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.needsBalancing) {
            this.balanceSlots();
        }
        if (this.isJammed) {
            return;
        }
        if (this.craftSlot == null) {
            this.craftSlot = new SlotCrafting((EntityPlayer)this.getInternalPlayer().get(), (IInventory)this.craftMatrix, (IInventory)this.craftResult, 0, 0, 0);
        }
        if (this.resultInv.getStackInSlot(0) != null) {
            return;
        }
        ++this.update;
        if (this.update % 16 == 0) {
            this.updateCrafting();
        }
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 256;
    }

    private void balanceSlots() {
        for (IInvSlot slotA : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stackA = slotA.getStackInSlot();
            if (stackA == null) continue;
            for (IInvSlot slotB : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
                ItemStack stackB;
                if (slotA.getIndex() == slotB.getIndex() || (stackB = slotB.getStackInSlot()) == null || !StackHelper.canStacksMerge(stackA, stackB) || stackA.stackSize <= stackB.stackSize + 1) continue;
                --stackA.stackSize;
                ++stackB.stackSize;
                return;
            }
        }
        this.needsBalancing = false;
    }

    private void updateCrafting() {
        IRecipe recipe = this.findRecipe();
        if (recipe == null) {
            this.progress = 0;
            this.isJammed = true;
            return;
        }
        if (!this.useLast && this.isLast()) {
            this.progress = 0;
            this.isJammed = true;
            return;
        }
        this.progress += 16;
        if (this.progress < 256) {
            return;
        }
        this.progress = 0;
        this.useLast = false;
        ItemStack result = recipe.getCraftingResult(this.craftMatrix);
        if (result == null) {
            this.isJammed = true;
            return;
        }
        result = result.copy();
        this.craftSlot.onPickupFromSlot((EntityPlayer)this.getInternalPlayer().get(), result);
        this.resultInv.setInventorySlotContents(0, result);
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)((EntityPlayer)this.getInternalPlayer().get()).inventory, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null) continue;
            slot.setStackInSlot(null);
            InvUtils.dropItems(this.worldObj, stack, this.xCoord, this.yCoord + 1, this.zCoord);
        }
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (!stack.isStackable()) {
            return false;
        }
        if (stack.getItem().hasContainerItem(stack)) {
            return false;
        }
        return this.getStackInSlot(slot) != null;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean isLast() {
        int minStackSize = 64;
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.craftMatrix, ForgeDirection.UP)) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || stack.stackSize >= minStackSize) continue;
            minStackSize = stack.stackSize;
        }
        return minStackSize <= 1;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean canInteractWith(EntityPlayer entityplayer) {
                    return false;
                }
            }, 3, 3);
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            super.setInventorySlotContents(slot, stack);
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
        }

        public void markDirty() {
            super.markDirty();
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
        }

        public ItemStack decrStackSize(int slot, int amount) {
            TileAutoWorkbench.this.isJammed = false;
            TileAutoWorkbench.this.needsBalancing = true;
            return super.decrStackSize(slot, amount);
        }
    }
}

