/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.utils.BlockUtils;
import buildcraft.factory.BlockMiner;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMiningWell
extends TileBuildCraft
implements IHasWork,
IPipeConnection,
IControllable {
    boolean isDigging = true;
    private BlockMiner miner;

    public TileMiningWell() {
        this.setBattery(new RFBattery(20480, 880, 0));
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.mode == IControllable.Mode.Off) {
            if (this.miner != null) {
                this.miner.invalidate();
                this.miner = null;
            }
            this.isDigging = false;
            return;
        }
        if (this.getBattery().getEnergyStored() == 0) {
            return;
        }
        if (this.miner == null) {
            World world = this.worldObj;
            int depth = this.yCoord - 1;
            while (world.getBlock(this.xCoord, depth, this.zCoord) == BuildCraftFactory.plainPipeBlock) {
                --depth;
            }
            if (depth < 1 || depth < this.yCoord - BuildCraftFactory.miningDepth || !BlockUtils.canChangeBlock(world, this.xCoord, depth, this.zCoord)) {
                this.isDigging = false;
                this.getBattery().useEnergy(0, 10, false);
                return;
            }
            if (world.isAirBlock(this.xCoord, depth, this.zCoord) || world.getBlock(this.xCoord, depth, this.zCoord).isReplaceable((IBlockAccess)world, this.xCoord, depth, this.zCoord)) {
                if (this.getBattery().getEnergyStored() >= 240) {
                    this.getBattery().useEnergy(240, 240, false);
                    world.setBlock(this.xCoord, depth, this.zCoord, (Block)BuildCraftFactory.plainPipeBlock);
                }
            } else {
                this.miner = new BlockMiner(world, this, this.xCoord, depth, this.zCoord);
            }
        }
        if (this.miner != null) {
            this.isDigging = true;
            int usedEnergy = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
            this.getBattery().useEnergy(usedEnergy, usedEnergy, false);
            if (this.miner.hasMined()) {
                if (this.miner.hasFailed()) {
                    this.isDigging = false;
                }
                this.miner = null;
            }
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.miner != null) {
            this.miner.invalidate();
        }
        if (this.worldObj != null && this.yCoord > 2) {
            BuildCraftFactory.miningWellBlock.removePipes(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean hasWork() {
        return this.isDigging;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }
}

