/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.EntityBlock;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuffer;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.fluids.TankUtils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.Utils;
import buildcraft.factory.FactoryProxy;
import io.netty.buffer.ByteBuf;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TilePump
extends TileBuildCraft
implements IHasWork,
IFluidHandler,
IRedstoneEngineReceiver {
    public static final int REBUID_DELAY = 512;
    public static int MAX_LIQUID = 16000;
    public SingleUseTank tank = new SingleUseTank("tank", MAX_LIQUID, this);
    private EntityBlock tube;
    private TreeMap<Integer, Deque<BlockIndex>> pumpLayerQueues = new TreeMap();
    private double tubeY = Double.NaN;
    private int aimY = 0;
    private SafeTimeTracker timer = new SafeTimeTracker(512L);
    private int tick = Utils.RANDOM.nextInt();
    private int numFluidBlocksFound = 0;
    private boolean powered = false;

    public TilePump() {
        this.setBattery(new RFBattery(1000, 150, 0));
    }

    @Override
    public void updateEntity() {
        FluidStack fluidToPump;
        super.updateEntity();
        if (this.powered) {
            this.pumpLayerQueues.clear();
            this.destroyTube();
        } else {
            this.createTube();
        }
        if (this.worldObj.isRemote) {
            return;
        }
        this.pushToConsumers();
        if (this.powered) {
            return;
        }
        if (this.tube == null) {
            return;
        }
        if (this.tube.posY - (double)this.aimY > 0.01) {
            this.tubeY = this.tube.posY - 0.01;
            this.setTubePosition();
            this.sendNetworkUpdate();
            return;
        }
        ++this.tick;
        if (this.tick % 16 != 0) {
            return;
        }
        BlockIndex index = this.getNextIndexToPump(false);
        FluidStack fluidStack = fluidToPump = index != null ? BlockUtils.drainBlock(this.worldObj, index.x, index.y, index.z, false) : null;
        if (fluidToPump != null) {
            if (this.isFluidAllowed(fluidToPump.getFluid()) && this.tank.fill(fluidToPump, false) == fluidToPump.amount && this.getBattery().useEnergy(100, 100, false) > 0) {
                if (fluidToPump.getFluid() != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) {
                    index = this.getNextIndexToPump(true);
                    BlockUtils.drainBlock(this.worldObj, index.x, index.y, index.z, true);
                }
                this.tank.fill(fluidToPump, true);
            }
        } else if (this.tick % 128 == 0) {
            this.rebuildQueue();
            if (this.getNextIndexToPump(false) == null) {
                for (int y = this.yCoord - 1; y > 0; --y) {
                    if (this.isPumpableFluid(this.xCoord, y, this.zCoord)) {
                        this.aimY = y;
                        return;
                    }
                    if (!this.isBlocked(this.xCoord, y, this.zCoord)) continue;
                    return;
                }
            }
        }
    }

    public void onNeighborBlockChange(Block block) {
        boolean p = this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
        if (this.powered != p) {
            this.powered = p;
            if (!this.worldObj.isRemote) {
                this.sendNetworkUpdate();
            }
        }
    }

    private boolean isBlocked(int x, int y, int z) {
        Material mat = this.worldObj.getBlock(x, y, z).getMaterial();
        return mat.blocksMovement();
    }

    private void pushToConsumers() {
        if (this.cache == null) {
            this.cache = TileBuffer.makeBuffer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, false);
        }
        TankUtils.pushFluidToConsumers((IFluidTank)this.tank, 400, this.cache);
    }

    private void createTube() {
        if (this.tube == null) {
            this.tube = FactoryProxy.proxy.newPumpTube(this.worldObj);
            this.tube.posY = !Double.isNaN(this.tubeY) ? this.tubeY : (double)this.yCoord;
            this.tubeY = this.tube.posY;
            if (this.aimY == 0) {
                this.aimY = this.yCoord;
            }
            this.setTubePosition();
            this.worldObj.spawnEntityInWorld((Entity)this.tube);
            if (!this.worldObj.isRemote) {
                this.sendNetworkUpdate();
            }
        }
    }

    private void destroyTube() {
        if (this.tube != null) {
            CoreProxy.proxy.removeEntity(this.tube);
            this.tube = null;
            this.tubeY = Double.NaN;
            this.aimY = 0;
        }
    }

    private BlockIndex getNextIndexToPump(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            if (this.timer.markTimeIfDelay(this.worldObj)) {
                this.rebuildQueue();
            }
            return null;
        }
        Deque<BlockIndex> topLayer = this.pumpLayerQueues.lastEntry().getValue();
        if (topLayer != null) {
            if (topLayer.isEmpty()) {
                this.pumpLayerQueues.pollLastEntry();
            }
            if (remove) {
                BlockIndex index = topLayer.pollLast();
                return index;
            }
            return topLayer.peekLast();
        }
        return null;
    }

    private Deque<BlockIndex> getLayerQueue(int layer) {
        Deque<BlockIndex> pumpQueue = this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList<BlockIndex>();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    public void rebuildQueue() {
        this.numFluidBlocksFound = 0;
        this.pumpLayerQueues.clear();
        int x = this.xCoord;
        int y = this.aimY;
        int z = this.zCoord;
        Fluid pumpingFluid = BlockUtils.getFluid(this.worldObj.getBlock(x, y, z));
        if (pumpingFluid == null) {
            return;
        }
        if (pumpingFluid != this.tank.getAcceptedFluid() && this.tank.getAcceptedFluid() != null) {
            return;
        }
        HashSet<BlockIndex> visitedBlocks = new HashSet<BlockIndex>();
        LinkedList<BlockIndex> fluidsFound = new LinkedList<BlockIndex>();
        this.queueForPumping(x, y, z, visitedBlocks, fluidsFound, pumpingFluid);
        while (!fluidsFound.isEmpty()) {
            LinkedList<BlockIndex> fluidsToExpand = fluidsFound;
            fluidsFound = new LinkedList();
            for (BlockIndex index : fluidsToExpand) {
                this.queueForPumping(index.x, index.y + 1, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x + 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x - 1, index.y, index.z, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z + 1, visitedBlocks, fluidsFound, pumpingFluid);
                this.queueForPumping(index.x, index.y, index.z - 1, visitedBlocks, fluidsFound, pumpingFluid);
                if (pumpingFluid != FluidRegistry.WATER || BuildCraftCore.consumeWaterSources || this.numFluidBlocksFound < 9) continue;
                return;
            }
        }
    }

    public void queueForPumping(int x, int y, int z, Set<BlockIndex> visitedBlocks, Deque<BlockIndex> fluidsFound, Fluid pumpingFluid) {
        BlockIndex index = new BlockIndex(x, y, z);
        if (visitedBlocks.add(index)) {
            if ((x - this.xCoord) * (x - this.xCoord) + (z - this.zCoord) * (z - this.zCoord) > 4096) {
                return;
            }
            Block block = this.worldObj.getBlock(x, y, z);
            if (BlockUtils.getFluid(block) == pumpingFluid) {
                fluidsFound.add(index);
            }
            if (this.canDrainBlock(block, x, y, z, pumpingFluid)) {
                this.getLayerQueue(y).add(index);
                ++this.numFluidBlocksFound;
            }
        }
    }

    private boolean isPumpableFluid(int x, int y, int z) {
        Fluid fluid = BlockUtils.getFluid(this.worldObj.getBlock(x, y, z));
        if (fluid == null) {
            return false;
        }
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        return this.tank.getAcceptedFluid() == null || this.tank.getAcceptedFluid() == fluid;
    }

    private boolean canDrainBlock(Block block, int x, int y, int z, Fluid fluid) {
        if (!this.isFluidAllowed(fluid)) {
            return false;
        }
        FluidStack fluidStack = BlockUtils.drainBlock(block, this.worldObj, x, y, z, false);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return false;
        }
        return fluidStack.getFluid() == fluid;
    }

    private boolean isFluidAllowed(Fluid fluid) {
        return BuildCraftFactory.pumpDimensionList.isFluidAllowed(fluid, this.worldObj.provider.dimensionId);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tank.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        this.aimY = data.getInteger("aimY");
        this.tubeY = data.getFloat("tubeY");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.tank.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setInteger("aimY", this.aimY);
        if (this.tube != null) {
            data.setFloat("tubeY", (float)this.tube.posY);
        } else {
            data.setFloat("tubeY", (float)this.yCoord);
        }
    }

    @Override
    public boolean hasWork() {
        BlockIndex next = this.getNextIndexToPump(false);
        if (next != null) {
            return this.isPumpableFluid(next.x, next.y, next.z);
        }
        return false;
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeShort(this.aimY);
        buf.writeFloat((float)this.tubeY);
        buf.writeBoolean(this.powered);
    }

    @Override
    public void readData(ByteBuf data) {
        this.aimY = data.readShort();
        this.tubeY = data.readFloat();
        this.powered = data.readBoolean();
        this.setTubePosition();
    }

    private void setTubePosition() {
        if (this.tube != null) {
            this.tube.iSize = 0.5;
            this.tube.kSize = 0.5;
            this.tube.jSize = (double)this.yCoord - this.tube.posY;
            this.tube.setPosition((float)this.xCoord + 0.25f, this.tubeY, (float)this.zCoord + 0.25f);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.destroy();
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public void destroy() {
        this.pumpLayerQueues.clear();
        this.destroyTube();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canConnectRedstoneEngine(ForgeDirection side) {
        return true;
    }
}

