/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftFactory;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.Box;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.RFBattery;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import buildcraft.core.utils.Utils;
import buildcraft.factory.BlockMiner;
import buildcraft.factory.EntityMechanicalArm;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileQuarry
extends TileAbstractBuilder
implements IHasWork,
ISidedInventory,
IDropControlInventory,
IPipeConnection,
IControllable {
    public EntityMechanicalArm arm;
    public EntityPlayer placedBy;
    protected Box box = new Box();
    private int targetX;
    private int targetY;
    private int targetZ;
    private double headPosX;
    private double headPosY;
    private double headPosZ;
    private double speed = 0.03;
    private Stage stage = Stage.BUILDING;
    private boolean movingHorizontally;
    private boolean movingVertically;
    private double headTrajectory;
    private SafeTimeTracker updateTracker = new SafeTimeTracker(10L);
    private BptBuilderBase builder;
    private final LinkedList<int[]> visitList = Lists.newLinkedList();
    private boolean loadDefaultBoundaries = false;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean frameProducer = true;
    private NBTTagCompound initNBT = null;
    private BlockMiner miner;

    public TileQuarry() {
        this.box.kind = Box.Kind.STRIPES;
        this.setBattery(new RFBattery((int)(20480.0f * BuildCraftFactory.miningMultiplier), (int)(1000.0f * BuildCraftFactory.miningMultiplier), 0));
    }

    public void createUtilsIfNeeded() {
        if (!this.worldObj.isRemote && this.builder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBlueprintBuilder();
        }
        if (this.stage != Stage.BUILDING) {
            this.box.isVisible = false;
            if (this.arm == null) {
                this.createArm();
            }
            if (this.findTarget(false) && this.box != null && (this.headPosX < (double)this.box.xMin || this.headPosX > (double)this.box.xMax || this.headPosZ < (double)this.box.zMin || this.headPosZ > (double)this.box.zMax)) {
                this.setHead(this.box.xMin + 1, this.yCoord + 2, this.box.zMin + 1);
            }
        } else {
            this.box.isVisible = true;
        }
    }

    private void createArm() {
        this.worldObj.spawnEntityInWorld((Entity)new EntityMechanicalArm(this.worldObj, (float)this.box.xMin + 0.75f, (float)(this.yCoord + this.box.sizeY() - 1) + 0.25f, (float)this.box.zMin + 0.75f, (float)(this.box.sizeX() - 2) + 0.5f, (float)(this.box.sizeZ() - 2) + 0.5f, this));
    }

    public void setArm(EntityMechanicalArm arm) {
        this.arm = arm;
    }

    public boolean areChunksLoaded() {
        if (BuildCraftFactory.quarryLoadsChunks) {
            return true;
        }
        return this.worldObj.blockExists(this.box.xMin, this.box.yMax, this.box.zMin) && this.worldObj.blockExists(this.box.xMax, this.box.yMax, this.box.zMin) && this.worldObj.blockExists(this.box.xMin, this.box.yMax, this.box.zMax) && this.worldObj.blockExists(this.box.xMax, this.box.yMax, this.box.zMax);
    }

    @Override
    public void updateEntity() {
        int energyUsed;
        super.updateEntity();
        if (this.worldObj.isRemote) {
            if (this.stage != Stage.DONE) {
                this.moveHead(this.speed);
            }
            return;
        }
        if (this.stage == Stage.DONE) {
            return;
        }
        if (!this.areChunksLoaded()) {
            return;
        }
        if (this.mode == IControllable.Mode.Off && this.stage != Stage.MOVING) {
            return;
        }
        if (this.stage == Stage.BUILDING) {
            if (this.builder != null && !this.builder.isDone(this)) {
                this.builder.buildNextSlot(this.worldObj, this, this.xCoord, this.yCoord, this.zCoord);
            } else {
                this.stage = Stage.IDLE;
            }
        } else if (this.stage == Stage.DIGGING) {
            this.dig();
        } else if (this.stage == Stage.IDLE) {
            this.idling();
        } else if (this.stage == Stage.MOVING && (energyUsed = this.getBattery().useEnergy(20, (int)Math.ceil(20 + this.getBattery().getEnergyStored() / 10), false)) >= 20) {
            this.speed = 0.1 + (double)((float)energyUsed / 2000.0f);
            if (this.worldObj.isRaining()) {
                int headBPX = (int)Math.floor(this.headPosX);
                int headBPY = (int)Math.floor(this.headPosY);
                int headBPZ = (int)Math.floor(this.headPosZ);
                if (this.worldObj.getHeightValue(headBPX, headBPZ) < headBPY) {
                    this.speed *= 0.7;
                }
            }
            this.moveHead(this.speed);
        }
        this.createUtilsIfNeeded();
        if (this.updateTracker.markTimeIfDelay(this.worldObj)) {
            this.sendNetworkUpdate();
        }
    }

    protected void dig() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.miner == null) {
            this.stage = Stage.IDLE;
            return;
        }
        int rfTaken = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
        this.getBattery().useEnergy(rfTaken, rfTaken, false);
        if (this.miner.hasMined()) {
            double[] head = this.getHead();
            AxisAlignedBB axis = AxisAlignedBB.getBoundingBox((double)(head[0] - 2.0), (double)(head[1] - 2.0), (double)(head[2] - 2.0), (double)(head[0] + 3.0), (double)(head[1] + 3.0), (double)(head[2] + 3.0));
            List result = this.worldObj.getEntitiesWithinAABB(EntityItem.class, axis);
            for (int ii = 0; ii < result.size(); ++ii) {
                if (!(result.get(ii) instanceof EntityItem)) continue;
                EntityItem entity = (EntityItem)result.get(ii);
                if (entity.isDead) continue;
                ItemStack mineable = entity.getEntityItem();
                if (mineable.stackSize <= 0) continue;
                CoreProxy.proxy.removeEntity((Entity)entity);
                this.miner.mineStack(mineable);
            }
            this.stage = Stage.IDLE;
            this.miner = null;
        }
    }

    protected void idling() {
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.setTarget(this.box.xMin + 1, this.yCoord + 2, this.box.zMin + 1);
            }
            this.stage = Stage.DONE;
        } else {
            this.stage = Stage.MOVING;
        }
        this.movingHorizontally = true;
        this.movingVertically = true;
        double[] head = this.getHead();
        int[] target = this.getTarget();
        this.headTrajectory = Math.atan2((double)target[2] - head[2], (double)target[0] - head[0]);
        this.sendNetworkUpdate();
    }

    public boolean findTarget(boolean doSet) {
        if (this.worldObj.isRemote) {
            return false;
        }
        boolean columnVisitListIsUpdated = false;
        if (this.visitList.isEmpty()) {
            this.createColumnVisitList();
            columnVisitListIsUpdated = true;
        }
        if (!doSet) {
            return !this.visitList.isEmpty();
        }
        if (this.visitList.isEmpty()) {
            return false;
        }
        int[] nextTarget = this.visitList.removeFirst();
        if (!columnVisitListIsUpdated) {
            for (int y = nextTarget[1] + 1; y < this.yCoord + 3; ++y) {
                Block block = this.worldObj.getBlock(nextTarget[0], y, nextTarget[2]);
                if (!BlockUtils.isAnObstructingBlock(block, this.worldObj, nextTarget[0], y, nextTarget[2]) && BuildCraftAPI.isSoftBlock(this.worldObj, nextTarget[0], y, nextTarget[2])) continue;
                this.createColumnVisitList();
                columnVisitListIsUpdated = true;
                nextTarget = null;
                break;
            }
        }
        if (columnVisitListIsUpdated && nextTarget == null && !this.visitList.isEmpty()) {
            nextTarget = this.visitList.removeFirst();
        } else if (columnVisitListIsUpdated && nextTarget == null) {
            return false;
        }
        this.setTarget(nextTarget[0], nextTarget[1] + 1, nextTarget[2]);
        return true;
    }

    private void createColumnVisitList() {
        this.visitList.clear();
        Integer[][] columnHeights = new Integer[this.builder.blueprint.sizeX - 2][this.builder.blueprint.sizeZ - 2];
        boolean[][] blockedColumns = new boolean[this.builder.blueprint.sizeX - 2][this.builder.blueprint.sizeZ - 2];
        for (int searchY = this.yCoord + 3; searchY >= 0; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.builder.blueprint.sizeX - 2;
                incX = 1;
            } else {
                startX = this.builder.blueprint.sizeX - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.builder.blueprint.sizeZ - 2;
                    incZ = 1;
                } else {
                    startZ = this.builder.blueprint.sizeZ - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    Integer height = columnHeights[searchX][searchZ];
                    int bx = this.box.xMin + searchX + 1;
                    int by = searchY;
                    int bz = this.box.zMin + searchZ + 1;
                    if (height == null) {
                        columnHeights[searchX][searchZ] = height = Integer.valueOf(this.worldObj.getHeightValue(bx, bz));
                    }
                    if (height > 0 && height < by && this.worldObj.provider.dimensionId != -1) continue;
                    Block block = this.worldObj.getBlock(bx, by, bz);
                    if (!BlockUtils.canChangeBlock(block, this.worldObj, bx, by, bz)) {
                        blockedColumns[searchX][searchZ] = true;
                    } else if (!BuildCraftAPI.isSoftBlock(this.worldObj, bx, by, bz)) {
                        this.visitList.add(new int[]{bx, by, bz});
                    }
                    if (height == 0 && !this.worldObj.isAirBlock(bx, by, bz)) {
                        columnHeights[searchX][searchZ] = by;
                    }
                    if (this.visitList.size() <= this.builder.blueprint.sizeZ * this.builder.blueprint.sizeX * 2) continue;
                    return;
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("box")) {
            this.box.initialize(nbttagcompound.getCompoundTag("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.hasKey("xSize")) {
            int xMin = nbttagcompound.getInteger("xMin");
            int zMin = nbttagcompound.getInteger("zMin");
            int xSize = nbttagcompound.getInteger("xSize");
            int ySize = nbttagcompound.getInteger("ySize");
            int zSize = nbttagcompound.getInteger("zSize");
            this.box.initialize(xMin, this.yCoord, zMin, xMin + xSize - 1, this.yCoord + ySize - 1, zMin + zSize - 1);
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        this.targetX = nbttagcompound.getInteger("targetX");
        this.targetY = nbttagcompound.getInteger("targetY");
        this.targetZ = nbttagcompound.getInteger("targetZ");
        this.headPosX = nbttagcompound.getDouble("headPosX");
        this.headPosY = nbttagcompound.getDouble("headPosY");
        this.headPosZ = nbttagcompound.getDouble("headPosZ");
        this.initNBT = (NBTTagCompound)nbttagcompound.getCompoundTag("bpt").copy();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("targetX", this.targetX);
        nbttagcompound.setInteger("targetY", this.targetY);
        nbttagcompound.setInteger("targetZ", this.targetZ);
        nbttagcompound.setDouble("headPosX", this.headPosX);
        nbttagcompound.setDouble("headPosY", this.headPosY);
        nbttagcompound.setDouble("headPosZ", this.headPosZ);
        NBTTagCompound boxTag = new NBTTagCompound();
        this.box.writeToNBT(boxTag);
        nbttagcompound.setTag("box", (NBTBase)boxTag);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.builder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.builder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.setTag("builderState", (NBTBase)builderCpt);
        }
        nbttagcompound.setTag("bpt", (NBTBase)bptNBT);
    }

    public void positionReached() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.isQuarriableBlock(this.targetX, this.targetY - 1, this.targetZ)) {
            this.miner = new BlockMiner(this.worldObj, this, this.targetX, this.targetY - 1, this.targetZ);
            this.stage = Stage.DIGGING;
        } else {
            this.stage = Stage.IDLE;
        }
    }

    private boolean isQuarriableBlock(int bx, int by, int bz) {
        Block block = this.worldObj.getBlock(bx, by, bz);
        return BlockUtils.canChangeBlock(block, this.worldObj, bx, by, bz) && !BuildCraftAPI.isSoftBlock(this.worldObj, bx, by, bz);
    }

    @Override
    public void invalidate() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.invalidate();
        this.destroy();
    }

    public void onChunkUnload() {
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.arm != null) {
            this.arm.setDead();
        }
        this.arm = null;
        this.frameProducer = false;
        if (this.miner != null) {
            this.miner.invalidate();
        }
    }

    @Override
    public boolean hasWork() {
        return this.mode != IControllable.Mode.Off && this.stage != Stage.DONE;
    }

    private void setBoundaries(boolean useDefaultI) {
        boolean useDefault = useDefaultI;
        if (BuildCraftFactory.quarryLoadsChunks && this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)BuildCraftFactory.instance, (World)this.worldObj, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket != null) {
            this.chunkTicket.getModData().setInteger("quarryX", this.xCoord);
            this.chunkTicket.getModData().setInteger("quarryY", this.yCoord);
            this.chunkTicket.getModData().setInteger("quarryZ", this.zCoord);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.xCoord >> 4, this.zCoord >> 4));
        }
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 10, this.yCoord + 4, this.zCoord + 10);
            useDefault = true;
        }
        int xSize = a.xMax() - a.xMin() + 1;
        int zSize = a.zMax() - a.zMin() + 1;
        if (this.chunkTicket != null && (xSize < 3 || zSize < 3 || xSize * zSize >> 8 >= this.chunkTicket.getMaxChunkListDepth())) {
            if (this.placedBy != null) {
                this.placedBy.addChatMessage((IChatComponent)new ChatComponentText(String.format("Quarry size is outside of chunkloading bounds or too small %d %d (%d)", xSize, zSize, this.chunkTicket.getMaxChunkListDepth())));
            }
            a = new DefaultAreaProvider(this.xCoord, this.yCoord, this.zCoord, this.xCoord + 10, this.yCoord + 4, this.zCoord + 10);
            useDefault = true;
        }
        xSize = a.xMax() - a.xMin() + 1;
        int ySize = a.yMax() - a.yMin() + 1;
        zSize = a.zMax() - a.zMin() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.yMax = this.box.yMin + ySize - 1;
        }
        if (useDefault) {
            int zMin;
            int xMin;
            ForgeDirection o = ForgeDirection.values()[this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord)].getOpposite();
            switch (o) {
                case EAST: {
                    xMin = this.xCoord + 1;
                    zMin = this.zCoord - 4 - 1;
                    break;
                }
                case WEST: {
                    xMin = this.xCoord - 9 - 2;
                    zMin = this.zCoord - 4 - 1;
                    break;
                }
                case SOUTH: {
                    xMin = this.xCoord - 4 - 1;
                    zMin = this.zCoord + 1;
                    break;
                }
                default: {
                    xMin = this.xCoord - 4 - 1;
                    zMin = this.zCoord - 9 - 2;
                }
            }
            this.box.initialize(xMin, this.yCoord, zMin, xMin + xSize - 1, this.yCoord + ySize - 1, zMin + zSize - 1);
        }
        a.removeFromWorld();
        if (this.chunkTicket != null) {
            this.forceChunkLoading(this.chunkTicket);
        }
        this.sendNetworkUpdate();
    }

    private void initializeBlueprintBuilder() {
        Blueprint bpt = ((FillerPattern)FillerManager.registry.getPattern("buildcraft:frame")).getBlueprint(this.box, this.worldObj, new IStatementParameter[0], BuildCraftFactory.frameBlock, 0);
        if (bpt != null) {
            this.builder = new BptBuilderBlueprint(bpt, this.worldObj, this.box.xMin, this.yCoord, this.box.zMin);
            this.stage = Stage.BUILDING;
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        stream.writeInt(this.targetX);
        stream.writeShort(this.targetY);
        stream.writeInt(this.targetZ);
        stream.writeDouble(this.headPosX);
        stream.writeDouble(this.headPosY);
        stream.writeDouble(this.headPosZ);
        stream.writeFloat((float)this.speed);
        stream.writeFloat((float)this.headTrajectory);
        int flags = this.stage.ordinal();
        flags |= this.movingHorizontally ? 16 : 0;
        stream.writeByte(flags |= this.movingVertically ? 32 : 0);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        this.targetX = stream.readInt();
        this.targetY = stream.readUnsignedShort();
        this.targetZ = stream.readInt();
        this.headPosX = stream.readDouble();
        this.headPosY = stream.readDouble();
        this.headPosZ = stream.readDouble();
        this.speed = stream.readFloat();
        this.headTrajectory = stream.readFloat();
        short flags = stream.readUnsignedByte();
        this.stage = Stage.values()[flags & 7];
        this.movingHorizontally = (flags & 0x10) != 0;
        this.movingVertically = (flags & 0x20) != 0;
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.getWorldObj().isRemote && !this.box.initialized) {
            this.setBoundaries(false);
        }
        this.createUtilsIfNeeded();
        if (this.initNBT != null && this.builder != null) {
            this.builder.loadBuildStateToNBT(this.initNBT.getCompoundTag("builderState"), this);
        }
        this.initNBT = null;
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.initializeBlueprintBuilder();
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int i) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftFactory.frameBlock);
        }
        return null;
    }

    public ItemStack decrStackSize(int i, int j) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftFactory.frameBlock, j);
        }
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public String getInventoryName() {
        return "";
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    public void moveHead(double instantSpeed) {
        int[] target = this.getTarget();
        double[] head = this.getHead();
        if (this.movingHorizontally) {
            if (Math.abs((double)target[0] - head[0]) < instantSpeed * 2.0 && Math.abs((double)target[2] - head[2]) < instantSpeed * 2.0) {
                head[0] = target[0];
                head[2] = target[2];
                this.movingHorizontally = false;
                if (!this.movingVertically) {
                    this.positionReached();
                    head[1] = target[1];
                }
            } else {
                head[0] = head[0] + Math.cos(this.headTrajectory) * instantSpeed;
                head[2] = head[2] + Math.sin(this.headTrajectory) * instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        if (this.movingVertically) {
            if (Math.abs((double)target[1] - head[1]) < instantSpeed * 2.0) {
                head[1] = target[1];
                this.movingVertically = false;
                if (!this.movingHorizontally) {
                    this.positionReached();
                    head[0] = target[0];
                    head[2] = target[2];
                }
            } else {
                head[1] = (double)target[1] > head[1] ? head[1] + instantSpeed : head[1] - instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.arm != null && this.worldObj.isRemote) {
            this.arm.setHead(this.headPosX, this.headPosY, this.headPosZ);
            this.arm.updatePosition();
        }
    }

    private void setHead(double x, double y, double z) {
        this.headPosX = x;
        this.headPosY = y;
        this.headPosZ = z;
    }

    private double[] getHead() {
        return new double[]{this.headPosX, this.headPosY, this.headPosZ};
    }

    private int[] getTarget() {
        return new int[]{this.targetX, this.targetY, this.targetZ};
    }

    private void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.xCoord >> 4, this.zCoord >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
        for (int chunkX = this.box.xMin >> 4; chunkX <= this.box.xMax >> 4; ++chunkX) {
            for (int chunkZ = this.box.zMin >> 4; chunkZ <= this.box.zMax >> 4; ++chunkZ) {
                ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                chunks.add(chunk);
            }
        }
        if (this.placedBy != null && !(this.placedBy instanceof FakePlayer)) {
            this.placedBy.addChatMessage((IChatComponent)new ChatComponentText(String.format("[BUILDCRAFT] The quarry at %d %d %d will keep %d chunks loaded", this.xCoord, this.yCoord, this.zCoord, chunks.size())));
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.box).expand(50).getBoundingBox();
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int p1, ItemStack p2, int p3) {
        return false;
    }

    public boolean canExtractItem(int p1, ItemStack p2, int p3) {
        return false;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On;
    }

    @Override
    public boolean doDrop() {
        return false;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    private static enum Stage {
        BUILDING,
        DIGGING,
        MOVING,
        IDLE,
        DONE;

    }
}

