/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.RFBattery;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRefinery
extends TileBuildCraft
implements IFluidHandler,
IInventory,
IHasWork,
IFlexibleCrafter {
    public static int LIQUID_PER_SLOT = 4000;
    public IFlexibleRecipe<FluidStack> currentRecipe;
    public CraftingResult<FluidStack> craftingResult;
    public SingleUseTank[] tanks = new SingleUseTank[]{new SingleUseTank("tank1", LIQUID_PER_SLOT, this), new SingleUseTank("tank2", LIQUID_PER_SLOT, this)};
    public SingleUseTank result = new SingleUseTank("result", LIQUID_PER_SLOT, this);
    public TankManager<SingleUseTank> tankManager = new TankManager((Tank[])new SingleUseTank[]{this.tanks[0], this.tanks[1], this.result});
    public float animationSpeed = 1.0f;
    private short animationStage = 0;
    private SafeTimeTracker time = new SafeTimeTracker();
    private SafeTimeTracker updateNetworkTime = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private boolean isActive;
    private String currentRecipeId = "";

    public TileRefinery() {
        this.setBattery(new RFBattery(10000, 1500, 0));
    }

    public int getSizeInventory() {
        return 0;
    }

    public ItemStack getStackInSlot(int i) {
        return null;
    }

    public ItemStack decrStackSize(int i, int j) {
        return null;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
    }

    public String getInventoryName() {
        return null;
    }

    public int getInventoryStackLimit() {
        return 0;
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.worldObj.isRemote) {
            this.simpleAnimationIterate();
            return;
        }
        if (this.updateNetworkTime.markTimeIfDelay(this.worldObj)) {
            this.sendNetworkUpdate();
        }
        this.isActive = false;
        if (this.currentRecipe == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.fill(((FluidStack)this.craftingResult.crafted).copy(), false) != ((FluidStack)this.craftingResult.crafted).amount) {
            this.decreaseAnimation();
            return;
        }
        this.isActive = true;
        if (this.getBattery().getEnergyStored() >= this.craftingResult.energyCost) {
            this.increaseAnimation();
        } else {
            this.decreaseAnimation();
        }
        if (!this.time.markTimeIfDelay(this.worldObj, this.craftingResult.craftingTime)) {
            return;
        }
        if (this.getBattery().useEnergy(this.craftingResult.energyCost, this.craftingResult.energyCost, false) > 0) {
            CraftingResult<FluidStack> r = this.currentRecipe.craft(this, false);
            this.result.fill(((FluidStack)r.crafted).copy(), true);
        }
    }

    private boolean containsInput(FluidStack ingredient) {
        if (ingredient == null) {
            return true;
        }
        return this.tanks[0].getFluid() != null && this.tanks[0].getFluid().containsFluid(ingredient) || this.tanks[1].getFluid() != null && this.tanks[1].getFluid().containsFluid(ingredient);
    }

    private boolean consumeInput(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        if (this.tanks[0].getFluid() != null && this.tanks[0].getFluid().containsFluid(liquid)) {
            this.tanks[0].drain(liquid.amount, true);
            return true;
        }
        if (this.tanks[1].getFluid() != null && this.tanks[1].getFluid().containsFluid(liquid)) {
            this.tanks[1].drain(liquid.amount, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasWork() {
        return this.isActive;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.animationStage = data.getShort("animationStage");
        this.animationSpeed = data.getFloat("animationSpeed");
        this.updateRecipe();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        data.setShort("animationStage", this.animationStage);
        data.setFloat("animationSpeed", this.animationSpeed);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    public void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = (short)100;
            }
        } else if (this.animationStage > 0) {
            this.animationStage = (short)(this.animationStage - 1);
        }
    }

    public void increaseAnimation() {
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = (short)100;
        }
    }

    public void decreaseAnimation() {
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (short)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = (short)100;
            }
        } else if (this.animationStage > 0) {
            this.animationStage = (short)(this.animationStage - 1);
        }
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public void resetFilters() {
        for (SingleUseTank tank : this.tankManager) {
            tank.setAcceptedFluid(null);
        }
    }

    public void setFilter(int number, Fluid fluid) {
        ((SingleUseTank)((Object)this.tankManager.get(number))).setAcceptedFluid(fluid);
    }

    public Fluid getFilter(int number) {
        return ((SingleUseTank)((Object)this.tankManager.get(number))).getAcceptedFluid();
    }

    public void getGUINetworkData(int id, int data) {
        switch (id) {
            case 0: {
                this.setFilter(0, FluidRegistry.getFluid((int)data));
                break;
            }
            case 1: {
                this.setFilter(1, FluidRegistry.getFluid((int)data));
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.getFilter(0) != null) {
            iCrafting.sendProgressBarUpdate(container, 0, this.getFilter(0).getID());
        }
        if (this.getFilter(1) != null) {
            iCrafting.sendProgressBarUpdate(container, 1, this.getFilter(1).getID());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        FluidStack resourceUsing = resource.copy();
        if (RefineryRecipeManager.INSTANCE.getValidFluidStacks1().contains(resource)) {
            resourceUsing.amount -= (used += this.tanks[0].fill(resourceUsing, doFill));
        }
        if (RefineryRecipeManager.INSTANCE.getValidFluidStacks2().contains(resource)) {
            resourceUsing.amount -= (used += this.tanks[1].fill(resourceUsing, doFill));
        }
        this.updateRecipe();
        return used;
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        FluidStack r = this.result.drain(maxEmpty, doDrain);
        this.updateRecipe();
        return r;
    }

    private void updateRecipe() {
        this.currentRecipe = null;
        this.craftingResult = null;
        for (IFlexibleRecipe<FluidStack> recipe : RefineryRecipeManager.INSTANCE.getRecipes()) {
            this.craftingResult = recipe.craft(this, true);
            if (this.craftingResult == null) continue;
            this.currentRecipe = recipe;
            this.currentRecipeId = this.currentRecipe.getId();
            break;
        }
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.result.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeFloat(this.animationSpeed);
        Utils.writeUTF(stream, this.currentRecipeId);
        this.tankManager.writeData(stream);
    }

    @Override
    public void readData(ByteBuf stream) {
        this.animationSpeed = stream.readFloat();
        this.currentRecipeId = Utils.readUTF(stream);
        this.tankManager.readData(stream);
        this.currentRecipe = RefineryRecipeManager.INSTANCE.getRecipe(this.currentRecipeId);
        if (this.currentRecipe != null) {
            this.craftingResult = this.currentRecipe.craft(this, true);
        }
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public int getCraftingItemStackSize() {
        return 0;
    }

    @Override
    public ItemStack getCraftingItemStack(int slotid) {
        return null;
    }

    @Override
    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return null;
    }

    @Override
    public FluidStack getCraftingFluidStack(int tankid) {
        return this.tanks[tankid].getFluid();
    }

    @Override
    public FluidStack decrCraftingFluidStack(int tankid, int val) {
        FluidStack resultF;
        if (val >= this.tanks[tankid].getFluid().amount) {
            resultF = this.tanks[tankid].getFluid();
            this.tanks[tankid].setFluid(null);
        } else {
            resultF = this.tanks[tankid].getFluid().copy();
            resultF.amount = val;
            this.tanks[tankid].getFluid().amount -= val;
        }
        this.updateRecipe();
        return resultF;
    }

    @Override
    public int getCraftingFluidStackSize() {
        return this.tanks.length;
    }
}

