/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.gui.slots.SlotOutput;
import buildcraft.core.gui.slots.SlotUntouchable;
import buildcraft.core.gui.slots.SlotWorkbench;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.utils.StringUtils;
import buildcraft.factory.TileAutoWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ContainerAutoWorkbench
extends BuildCraftContainer {
    public IInventory craftResult = new InventoryCraftResult(){

        public void setInventorySlotContents(int slot, ItemStack stack) {
            super.setInventorySlotContents(slot, stack);
            if (stack != null && ContainerAutoWorkbench.this.tile.isLast() && ((ContainerAutoWorkbench)ContainerAutoWorkbench.this).tile.getWorldObj().isRemote) {
                InvUtils.addItemToolTip(stack, EnumChatFormatting.YELLOW + StringUtils.localize("gui.clickcraft"));
            }
        }
    };
    private final TileAutoWorkbench tile;
    private int lastProgress;
    private ItemStack prevOutput;

    public ContainerAutoWorkbench(InventoryPlayer inventoryplayer, TileAutoWorkbench t) {
        super(t.getSizeInventory());
        int x;
        int y;
        this.tile = t;
        this.addSlotToContainer(new SlotUntouchable(this.craftResult, 0, 93, 27){

            public void onPickupFromSlot(EntityPlayer player, ItemStack itemstack) {
                ((ContainerAutoWorkbench)ContainerAutoWorkbench.this).tile.useLast = true;
            }
        });
        this.addSlotToContainer(new SlotOutput((IInventory)this.tile, 0, 124, 35));
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 3; ++x) {
                this.addSlotToContainer(new SlotWorkbench((IInventory)this.tile.craftMatrix, x + y * 3, 30 + x * 18, 17 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.addSlotToContainer(new Slot((IInventory)inventoryplayer, x2, 8 + x2 * 18, 142));
        }
        this.onCraftMatrixChanged((IInventory)this.tile);
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.progress);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.crafters.get(i);
            if (this.lastProgress == this.tile.progress) continue;
            icrafting.sendProgressBarUpdate((Container)this, 0, this.tile.progress);
        }
        ItemStack output = this.craftResult.getStackInSlot(0);
        if (output != this.prevOutput) {
            this.prevOutput = output;
            this.onCraftMatrixChanged((IInventory)this.tile.craftMatrix);
        }
        this.lastProgress = this.tile.progress;
    }

    public void updateProgressBar(int id, int data) {
        switch (id) {
            case 0: {
                this.tile.progress = data;
            }
        }
    }

    public final void onCraftMatrixChanged(IInventory inv) {
        super.onCraftMatrixChanged(inv);
        ItemStack output = this.tile.findRecipeOutput();
        this.craftResult.setInventorySlotContents(0, output);
    }

    @Override
    public ItemStack slotClick(int i, int j, int modifier, EntityPlayer entityplayer) {
        ItemStack stack = super.slotClick(i, j, modifier, entityplayer);
        this.onCraftMatrixChanged((IInventory)this.tile.craftMatrix);
        return stack;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.tile.isUseableByPlayer(entityplayer);
    }
}

