/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory.gui;

import buildcraft.BuildCraftFactory;
import buildcraft.core.gui.BuildCraftContainer;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.network.Serializable;
import buildcraft.factory.TileRefinery;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fluids.Fluid;

public class ContainerRefinery
extends BuildCraftContainer {
    public TileRefinery refinery;

    public ContainerRefinery(InventoryPlayer inventory, TileRefinery refinery) {
        super(refinery.getSizeInventory());
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.addSlotToContainer(new Slot((IInventory)inventory, k1 + l * 9 + 9, 8 + k1 * 18, 123 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlotToContainer(new Slot((IInventory)inventory, i1, 8 + i1 * 18, 181));
        }
        this.refinery = refinery;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.refinery.isUseableByPlayer(entityplayer);
    }

    public void setFilter(final int slot, final Fluid filter) {
        this.refinery.setFilter(slot, filter);
        if (this.refinery.getWorldObj().isRemote) {
            Serializable payload = new Serializable(){

                @Override
                public void writeData(ByteBuf data) {
                    data.writeByte(slot);
                    data.writeShort(filter != null ? filter.getID() : -1);
                }
            };
            BuildCraftFactory.instance.sendToServer(new PacketUpdate(50, this.refinery.xCoord, this.refinery.yCoord, this.refinery.zCoord, payload));
        }
    }

    public Fluid getFilter(int slot) {
        return this.refinery.getFilter(slot);
    }

    public void updateProgressBar(int i, int j) {
        this.refinery.getGUINetworkData(i, j);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.crafters.size(); ++i) {
            this.refinery.sendGUINetworkData(this, (ICrafting)this.crafters.get(i));
        }
    }
}

