/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.RobotRegistry;
import buildcraft.transport.TileGenericPipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DockingStation
implements IDockingStation {
    public ForgeDirection side;
    public World world;
    private long robotTakingId = Long.MAX_VALUE;
    private EntityRobotBase robotTaking;
    private boolean linkIsMain = false;
    private BlockIndex index;
    private TileGenericPipe pipe;

    public DockingStation(BlockIndex iIndex, ForgeDirection iSide) {
        this.index = iIndex;
        this.side = iSide;
    }

    public DockingStation(TileGenericPipe iPipe, ForgeDirection iSide) {
        this.index = new BlockIndex(iPipe);
        this.pipe = iPipe;
        this.side = iSide;
        this.world = iPipe.getWorld();
    }

    public DockingStation() {
    }

    public boolean isMainStation() {
        return this.linkIsMain;
    }

    public TileGenericPipe getPipe() {
        if (this.pipe == null) {
            this.pipe = (TileGenericPipe)this.world.getTileEntity(this.index.x, this.index.y, this.index.z);
        }
        if (this.pipe == null || this.pipe.isInvalid()) {
            RobotRegistry.getRegistry(this.world).removeStation(this);
            this.pipe = null;
        }
        return this.pipe;
    }

    @Override
    public int x() {
        return this.index.x;
    }

    @Override
    public int y() {
        return this.index.y;
    }

    @Override
    public int z() {
        return this.index.z;
    }

    @Override
    public ForgeDirection side() {
        return this.side;
    }

    @Override
    public EntityRobotBase robotTaking() {
        if (this.robotTakingId == Long.MAX_VALUE) {
            return null;
        }
        if (this.robotTaking == null) {
            this.robotTaking = RobotRegistry.getRegistry(this.world).getLoadedRobot(this.robotTakingId);
        }
        return this.robotTaking;
    }

    public void invalidateRobotTakingEntity() {
        this.robotTaking = null;
    }

    @Override
    public long linkedId() {
        return this.robotTakingId;
    }

    public boolean takeAsMain(EntityRobotBase robot) {
        if (this.robotTakingId == Long.MAX_VALUE) {
            this.linkIsMain = true;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            this.getPipe().scheduleRenderUpdate();
            RobotRegistry.getRegistry(this.world).markDirty();
            ((EntityRobot)robot).setMainStation(this);
            RobotRegistry.getRegistry(this.world).take(this, robot.getRobotId());
            return true;
        }
        return this.robotTakingId == robot.getRobotId();
    }

    @Override
    public boolean take(EntityRobotBase robot) {
        if (this.robotTaking == null) {
            this.linkIsMain = false;
            this.robotTaking = robot;
            this.robotTakingId = robot.getRobotId();
            this.getPipe().scheduleRenderUpdate();
            RobotRegistry.getRegistry(this.world).markDirty();
            RobotRegistry.getRegistry(this.world).take(this, robot.getRobotId());
            return true;
        }
        return robot.getRobotId() == this.robotTakingId;
    }

    public void release(EntityRobotBase robot) {
        if (this.robotTaking == robot && !this.linkIsMain) {
            this.unsafeRelease(robot);
            RobotRegistry.getRegistry(this.world).markDirty();
            RobotRegistry.getRegistry(this.world).release(this, robot.getRobotId());
        }
    }

    public void unsafeRelease(EntityRobotBase robot) {
        if (this.robotTaking == robot) {
            this.linkIsMain = false;
            this.robotTaking = null;
            this.robotTakingId = Long.MAX_VALUE;
            this.getPipe().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound indexNBT = new NBTTagCompound();
        this.index.writeTo(indexNBT);
        nbt.setTag("index", (NBTBase)indexNBT);
        nbt.setByte("side", (byte)this.side.ordinal());
        nbt.setBoolean("isMain", this.linkIsMain);
        nbt.setLong("robotId", this.robotTakingId);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.index = new BlockIndex(nbt.getCompoundTag("index"));
        this.side = ForgeDirection.values()[nbt.getByte("side")];
        this.linkIsMain = nbt.getBoolean("isMain");
        this.robotTakingId = nbt.getLong("robotId");
    }

    @Override
    public boolean isTaken() {
        return this.robotTakingId != Long.MAX_VALUE;
    }

    @Override
    public long robotIdTaking() {
        return this.robotTakingId;
    }

    @Override
    public BlockIndex index() {
        return this.index;
    }

    public String toString() {
        return "{" + this.index.x + ", " + this.index.y + ", " + this.index.z + ", " + this.side + " :" + this.robotTakingId + "}";
    }

    public boolean linkIsDocked() {
        if (this.isTaken()) {
            return this.robotTaking().getDockingStation() == this;
        }
        return false;
    }

    public boolean canRelease() {
        return !this.isMainStation() && !this.linkIsDocked();
    }
}

