/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IZone;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import buildcraft.core.RFBattery;
import buildcraft.core.network.CommandWriter;
import buildcraft.core.network.ICommandReceiver;
import buildcraft.core.network.PacketCommand;
import buildcraft.core.utils.NBTUtils;
import buildcraft.core.utils.Utils;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobotEnergyParticle;
import buildcraft.robots.RobotRegistry;
import buildcraft.robots.ai.AIRobotMain;
import buildcraft.robots.statements.ActionRobotWorkInArea;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Date;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class EntityRobot
extends EntityRobotBase
implements IEntityAdditionalSpawnData,
IInventory,
IFluidHandler,
ICommandReceiver {
    public static final ResourceLocation ROBOT_BASE = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_base.png");
    public static final ResourceLocation ROBOT_BUILDER = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_builder.png");
    public static final ResourceLocation ROBOT_TRANSPORT = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_picker.png");
    public static final ResourceLocation ROBOT_FACTORY = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_factory.png");
    private static ResourceLocation defaultTexture = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_base.png");
    public SafeTimeTracker scanForTasks = new SafeTimeTracker(40L, 10L);
    public LaserData laser = new LaserData();
    public IDockingStation linkedDockingStation;
    public BlockIndex linkedDockingStationIndex;
    public ForgeDirection linkedDockingStationSide;
    public BlockIndex currentDockingStationIndex;
    public ForgeDirection currentDockingStationSide;
    public boolean isDocked = false;
    public NBTTagCompound originalBoardNBT;
    public RedstoneBoardRobot board;
    public AIRobotMain mainAI;
    public ItemStack itemInUse;
    public float itemAngle1 = 0.0f;
    public float itemAngle2 = 0.0f;
    public boolean itemActive = false;
    public float itemActiveStage = 0.0f;
    public long lastUpdateTime = 0L;
    private DockingStation currentDockingStation;
    private boolean needsUpdate = false;
    private ItemStack[] inv = new ItemStack[4];
    private FluidStack tank;
    private int maxFluid = 4000;
    private String boardID;
    private ResourceLocation texture;
    private WeakHashMap<Entity, Boolean> unreachableEntities = new WeakHashMap();
    private NBTTagList stackRequestNBT;
    private RFBattery battery = new RFBattery(100000, 100000, 100);
    private boolean firstUpdateDone = false;
    private long robotId = Long.MAX_VALUE;
    private int energySpendPerCycle = 0;
    private float energyFX = 0.0f;
    private int steamDx = 0;
    private int steamDy = -1;
    private int steamDz = 0;

    public EntityRobot(World world, NBTTagCompound boardNBT) {
        this(world);
        this.originalBoardNBT = boardNBT;
        this.board = (RedstoneBoardRobot)RedstoneBoardRegistry.instance.getRedstoneBoard(boardNBT).create(boardNBT, this);
        this.dataWatcher.updateObject(16, (Object)this.board.getNBTHandler().getID());
        if (!world.isRemote) {
            this.mainAI = new AIRobotMain(this);
            this.mainAI.start();
        }
    }

    public EntityRobot(World world) {
        super(world);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.ignoreFrustumCheck = true;
        this.laser.isVisible = false;
        this.entityCollisionReduction = 1.0f;
        this.width = 0.25f;
        this.height = 0.25f;
    }

    protected void entityInit() {
        super.entityInit();
        this.setNullBoundingBox();
        this.preventEntitySpawning = false;
        this.noClip = true;
        this.isImmuneToFire = true;
        this.func_110163_bv();
        this.dataWatcher.addObject(12, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(13, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(14, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(15, (Object)0);
        this.dataWatcher.addObject(16, (Object)"");
        this.dataWatcher.addObject(17, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(18, (Object)Float.valueOf(0.0f));
        this.dataWatcher.addObject(19, (Object)0);
    }

    protected void updateDataClient() {
        this.laser.tail.x = this.dataWatcher.getWatchableObjectFloat(12);
        this.laser.tail.y = this.dataWatcher.getWatchableObjectFloat(13);
        this.laser.tail.z = this.dataWatcher.getWatchableObjectFloat(14);
        this.laser.isVisible = this.dataWatcher.getWatchableObjectByte(15) == 1;
        RedstoneBoardNBT<?> boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(this.dataWatcher.getWatchableObjectString(16));
        if (boardNBT != null) {
            this.texture = ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        this.itemAngle1 = this.dataWatcher.getWatchableObjectFloat(17);
        this.itemAngle2 = this.dataWatcher.getWatchableObjectFloat(18);
        this.energySpendPerCycle = this.dataWatcher.getWatchableObjectInt(19);
    }

    protected void updateDataServer() {
        this.dataWatcher.updateObject(12, (Object)Float.valueOf((float)this.laser.tail.x));
        this.dataWatcher.updateObject(13, (Object)Float.valueOf((float)this.laser.tail.y));
        this.dataWatcher.updateObject(14, (Object)Float.valueOf((float)this.laser.tail.z));
        this.dataWatcher.updateObject(15, (Object)((byte)(this.laser.isVisible ? 1 : 0)));
        this.dataWatcher.updateObject(17, (Object)Float.valueOf(this.itemAngle1));
        this.dataWatcher.updateObject(18, (Object)Float.valueOf(this.itemAngle2));
        this.dataWatcher.updateObject(19, (Object)this.energySpendPerCycle);
    }

    protected void init() {
        if (this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToServer(new PacketCommand(this, "requestInitialization", null));
        }
    }

    public void setLaserDestination(float x, float y, float z) {
        if ((double)x != this.laser.tail.x || (double)y != this.laser.tail.y || (double)z != this.laser.tail.z) {
            this.laser.tail.x = x;
            this.laser.tail.y = y;
            this.laser.tail.z = z;
            this.needsUpdate = true;
        }
    }

    public void showLaser() {
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
            this.needsUpdate = true;
        }
    }

    public void hideLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            this.needsUpdate = true;
        }
    }

    protected void firstUpdate() {
        if (this.stackRequestNBT != null) {
            // empty if block
        }
        if (!this.worldObj.isRemote) {
            this.getRegistry().registerRobot(this);
        }
    }

    public void onEntityUpdate() {
        this.worldObj.theProfiler.startSection("bcEntityRobot");
        if (!this.firstUpdateDone) {
            this.firstUpdate();
            this.firstUpdateDone = true;
        }
        if (!this.worldObj.isRemote && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        if (this.worldObj.isRemote) {
            this.updateDataClient();
            this.energyFX += (float)this.energySpendPerCycle;
            if (this.energyFX >= 100.0f) {
                this.energyFX = 0.0f;
                this.spawnEnergyFX();
            }
        }
        if (this.currentDockingStation != null) {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.posX = (float)this.currentDockingStation.x() + 0.5f + (float)this.currentDockingStation.side().offsetX * 0.5f;
            this.posY = (float)this.currentDockingStation.y() + 0.5f + (float)this.currentDockingStation.side().offsetY * 0.5f;
            this.posZ = (float)this.currentDockingStation.z() + 0.5f + (float)this.currentDockingStation.side().offsetZ * 0.5f;
        }
        if (!this.worldObj.isRemote) {
            if (this.linkedDockingStation == null) {
                this.linkedDockingStation = RobotRegistry.getRegistry(this.worldObj).getStation(this.linkedDockingStationIndex.x, this.linkedDockingStationIndex.y, this.linkedDockingStationIndex.z, this.linkedDockingStationSide);
                if (this.linkedDockingStation == null || this.linkedDockingStation.robotTaking() != this) {
                    this.setDead();
                    return;
                }
            }
            if (this.currentDockingStationIndex != null && this.currentDockingStation == null) {
                this.currentDockingStation = (DockingStation)RobotRegistry.getRegistry(this.worldObj).getStation(this.currentDockingStationIndex.x, this.currentDockingStationIndex.y, this.currentDockingStationIndex.z, this.currentDockingStationSide);
            }
            if (this.linkedDockingStation != null) {
                this.worldObj.theProfiler.startSection("bcRobotAIMainCycle");
                this.mainAI.cycle();
                this.worldObj.theProfiler.endSection();
                if (this.energySpendPerCycle != this.mainAI.getActiveAI().getEnergyCost()) {
                    this.energySpendPerCycle = this.mainAI.getActiveAI().getEnergyCost();
                    this.needsUpdate = true;
                }
                if (this.battery.getEnergyStored() <= 0 && !this.linkedToChargeStation()) {
                    this.setDead();
                }
            }
        }
        super.onEntityUpdate();
        this.worldObj.theProfiler.endSection();
    }

    private boolean linkedToChargeStation() {
        if (this.currentDockingStation == null) {
            return false;
        }
        return this.currentDockingStation.getPipe().pipe.transport instanceof PipeTransportPower;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEnergyFX() {
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntityRobotEnergyParticle(this.worldObj, this.posX + (double)this.steamDx * 0.25, this.posY + (double)this.steamDy * 0.25, this.posZ + (double)this.steamDz * 0.25, (double)this.steamDx * 0.05, (double)this.steamDy * 0.05, (double)this.steamDz * 0.05, (float)this.energySpendPerCycle * 0.075f < 1.0f ? 1.0f : (float)this.energySpendPerCycle * 0.075f));
    }

    public void setRegularBoundingBox() {
        this.width = 0.5f;
        this.height = 0.5f;
        if (this.laser.isVisible) {
            this.boundingBox.minX = Math.min(this.posX, this.laser.tail.x);
            this.boundingBox.minY = Math.min(this.posY, this.laser.tail.y);
            this.boundingBox.minZ = Math.min(this.posZ, this.laser.tail.z);
            this.boundingBox.maxX = Math.max(this.posX, this.laser.tail.x);
            this.boundingBox.maxY = Math.max(this.posY, this.laser.tail.y);
            this.boundingBox.maxZ = Math.max(this.posZ, this.laser.tail.z);
            this.boundingBox.minX -= 1.0;
            this.boundingBox.minY -= 1.0;
            this.boundingBox.minZ -= 1.0;
            this.boundingBox.maxX += 1.0;
            this.boundingBox.maxY += 1.0;
            this.boundingBox.maxZ += 1.0;
        } else {
            this.boundingBox.minX = this.posX - 0.25;
            this.boundingBox.minY = this.posY - 0.25;
            this.boundingBox.minZ = this.posZ - 0.25;
            this.boundingBox.maxX = this.posX + 0.25;
            this.boundingBox.maxY = this.posY + 0.25;
            this.boundingBox.maxZ = this.posZ + 0.25;
        }
    }

    public void setNullBoundingBox() {
        this.width = 0.0f;
        this.height = 0.0f;
        this.boundingBox.minX = this.posX;
        this.boundingBox.minY = this.posY;
        this.boundingBox.minZ = this.posZ;
        this.boundingBox.maxX = this.posX;
        this.boundingBox.maxY = this.posY;
        this.boundingBox.maxZ = this.posZ;
    }

    private void iterateBehaviorDocked() {
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.setNullBoundingBox();
    }

    public void writeSpawnData(ByteBuf data) {
    }

    public void readSpawnData(ByteBuf data) {
        this.init();
    }

    public ItemStack getHeldItem() {
        return this.itemInUse;
    }

    public void setCurrentItemOrArmor(int i, ItemStack itemstack) {
    }

    public ItemStack[] getLastActiveItems() {
        return new ItemStack[0];
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public void moveEntityWithHeading(float par1, float par2) {
        this.setPosition(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
    }

    public boolean isOnLadder() {
        return false;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        NBTTagCompound linkedStationNBT = new NBTTagCompound();
        NBTTagCompound linkedStationIndexNBT = new NBTTagCompound();
        this.linkedDockingStationIndex.writeTo(linkedStationIndexNBT);
        linkedStationNBT.setTag("index", (NBTBase)linkedStationIndexNBT);
        linkedStationNBT.setByte("side", (byte)this.linkedDockingStationSide.ordinal());
        nbt.setTag("linkedStation", (NBTBase)linkedStationNBT);
        if (this.currentDockingStationIndex != null) {
            NBTTagCompound currentStationNBT = new NBTTagCompound();
            NBTTagCompound currentStationIndexNBT = new NBTTagCompound();
            this.currentDockingStationIndex.writeTo(currentStationIndexNBT);
            currentStationNBT.setTag("index", (NBTBase)currentStationIndexNBT);
            currentStationNBT.setByte("side", (byte)this.currentDockingStationSide.ordinal());
            nbt.setTag("currentStation", (NBTBase)currentStationNBT);
        }
        NBTTagCompound nbtLaser = new NBTTagCompound();
        this.laser.writeToNBT(nbtLaser);
        nbt.setTag("laser", (NBTBase)nbtLaser);
        NBTTagCompound batteryNBT = new NBTTagCompound();
        this.battery.writeToNBT(batteryNBT);
        nbt.setTag("battery", (NBTBase)batteryNBT);
        if (this.itemInUse != null) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            this.itemInUse.writeToNBT(itemNBT);
            nbt.setTag("itemInUse", (NBTBase)itemNBT);
            nbt.setBoolean("itemActive", this.itemActive);
        }
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound stackNbt = new NBTTagCompound();
            if (this.inv[i] == null) continue;
            nbt.setTag("inv[" + i + "]", (NBTBase)this.inv[i].writeToNBT(stackNbt));
        }
        nbt.setTag("originalBoardNBT", (NBTBase)this.originalBoardNBT);
        NBTTagCompound ai = new NBTTagCompound();
        this.mainAI.writeToNBT(ai);
        nbt.setTag("mainAI", (NBTBase)ai);
        if (this.mainAI.getDelegateAI() != this.board) {
            NBTTagCompound boardNBT = new NBTTagCompound();
            this.board.writeToNBT(boardNBT);
            nbt.setTag("board", (NBTBase)boardNBT);
        }
        nbt.setLong("robotId", this.robotId);
        if (this.tank != null) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            this.tank.writeToNBT(tankNBT);
            nbt.setTag("tank", (NBTBase)tankNBT);
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        NBTTagCompound linkedStationNBT = nbt.getCompoundTag("linkedStation");
        this.linkedDockingStationIndex = new BlockIndex(linkedStationNBT.getCompoundTag("index"));
        this.linkedDockingStationSide = ForgeDirection.values()[linkedStationNBT.getByte("side")];
        if (nbt.hasKey("currentStation")) {
            NBTTagCompound currentStationNBT = nbt.getCompoundTag("currentStation");
            this.currentDockingStationIndex = new BlockIndex(currentStationNBT.getCompoundTag("index"));
            this.currentDockingStationSide = ForgeDirection.values()[currentStationNBT.getByte("side")];
        }
        this.laser.readFromNBT(nbt.getCompoundTag("laser"));
        this.battery.readFromNBT(nbt.getCompoundTag("battery"));
        if (nbt.hasKey("itemInUse")) {
            this.itemInUse = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("itemInUse"));
            this.itemActive = nbt.getBoolean("itemActive");
        }
        for (int i = 0; i < this.inv.length; ++i) {
            this.inv[i] = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("inv[" + i + "]"));
        }
        this.originalBoardNBT = nbt.getCompoundTag("originalBoardNBT");
        NBTTagCompound ai = nbt.getCompoundTag("mainAI");
        this.mainAI = (AIRobotMain)AIRobot.loadAI(ai, this);
        this.board = nbt.hasKey("board") ? (RedstoneBoardRobot)AIRobot.loadAI(nbt.getCompoundTag("board"), this) : (RedstoneBoardRobot)this.mainAI.getDelegateAI();
        this.dataWatcher.updateObject(16, (Object)this.board.getNBTHandler().getID());
        this.stackRequestNBT = nbt.getTagList("stackRequests", 10);
        if (nbt.hasKey("robotId")) {
            this.robotId = nbt.getLong("robotId");
        }
        this.tank = nbt.hasKey("tank") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.getCompoundTag("tank")) : null;
        this.func_110163_bv();
    }

    @Override
    public void dock(IDockingStation station) {
        this.currentDockingStation = (DockingStation)station;
        this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
        this.currentDockingStationIndex = this.currentDockingStation.index();
        this.currentDockingStationSide = this.currentDockingStation.side();
    }

    @Override
    public void undock() {
        if (this.currentDockingStation != null) {
            this.currentDockingStation.release(this);
            this.currentDockingStation = null;
            this.setSteamDirection(0, -1, 0);
            this.currentDockingStationIndex = null;
            this.currentDockingStationSide = null;
        }
    }

    @Override
    public DockingStation getDockingStation() {
        return this.currentDockingStation;
    }

    public void setMainStation(IDockingStation iStation) {
        DockingStation station = (DockingStation)iStation;
        if (this.linkedDockingStation != null && this.linkedDockingStation != station) {
            ((DockingStation)this.linkedDockingStation).unsafeRelease(this);
        }
        this.linkedDockingStation = station;
        this.linkedDockingStationIndex = this.linkedDockingStation.index();
        this.linkedDockingStationSide = this.linkedDockingStation.side();
    }

    public ItemStack getEquipmentInSlot(int var1) {
        return null;
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int var1) {
        return this.inv[var1];
    }

    public ItemStack decrStackSize(int var1, int var2) {
        ItemStack result = this.inv[var1].splitStack(var2);
        if (this.inv[var1].stackSize == 0) {
            this.inv[var1] = null;
        }
        this.updateClientSlot(var1);
        return result;
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.inv[var1].splitStack(var1);
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.inv[var1] = var2;
        this.updateClientSlot(var1);
    }

    public String getInventoryName() {
        return null;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public void updateClientSlot(final int slot) {
        BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clientSetInventory", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                data.writeShort(slot);
                Utils.writeStack(data, EntityRobot.this.inv[slot]);
            }
        }), this.worldObj);
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return false;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int var1, ItemStack var2) {
        return this.inv[var1] == null || this.inv[var1].isItemEqual(var2) && this.inv[var1].isStackable() && this.inv[var1].stackSize + var2.stackSize <= this.inv[var1].getItem().getItemStackLimit(this.inv[var1]);
    }

    @Override
    public boolean isMoving() {
        return this.motionX != 0.0 || this.motionY != 0.0 || this.motionZ != 0.0;
    }

    @Override
    public void setItemInUse(ItemStack stack) {
        this.itemInUse = stack;
        BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "clientSetItemInUse", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                Utils.writeStack(data, EntityRobot.this.itemInUse);
            }
        }), this.worldObj);
    }

    private void setSteamDirection(final int x, final int y, final int z) {
        if (!this.worldObj.isRemote) {
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "setSteamDirection", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeInt(x);
                    data.writeShort(y);
                    data.writeInt(z);
                }
            }), this.worldObj);
        } else {
            Vec3 v = Vec3.createVectorHelper((double)x, (double)y, (double)z);
            v = v.normalize();
            this.steamDx = (int)v.xCoord;
            this.steamDy = (int)v.yCoord;
            this.steamDz = (int)v.zCoord;
        }
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("clientSetItemInUse".equals(command)) {
                this.itemInUse = Utils.readStack(stream);
            } else if ("clientSetInventory".equals(command)) {
                int slot = stream.readUnsignedShort();
                this.inv[slot] = Utils.readStack(stream);
            } else if ("initialize".equals(command)) {
                this.itemInUse = Utils.readStack(stream);
                this.itemActive = stream.readBoolean();
            } else if ("setItemActive".equals(command)) {
                this.itemActive = stream.readBoolean();
                this.itemActiveStage = 0.0f;
                this.lastUpdateTime = new Date().getTime();
                if (!this.itemActive) {
                    this.setSteamDirection(0, -1, 0);
                }
            } else if ("setSteamDirection".equals(command)) {
                this.setSteamDirection(stream.readInt(), stream.readShort(), stream.readInt());
            }
        } else if (side.isServer()) {
            EntityPlayer p = (EntityPlayer)sender;
            if ("requestInitialization".equals(command)) {
                BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "initialize", new CommandWriter(){

                    @Override
                    public void write(ByteBuf data) {
                        Utils.writeStack(data, EntityRobot.this.itemInUse);
                        data.writeBoolean(EntityRobot.this.itemActive);
                    }
                }));
                int i = 0;
                while (i < this.inv.length) {
                    final int j = i++;
                    BuildCraftCore.instance.sendToPlayer(p, new PacketCommand(this, "clientSetInventory", new CommandWriter(){

                        @Override
                        public void write(ByteBuf data) {
                            data.writeShort(j);
                            Utils.writeStack(data, EntityRobot.this.inv[j]);
                        }
                    }));
                }
                if (this.currentDockingStation != null) {
                    this.setSteamDirection(this.currentDockingStation.side.offsetX, this.currentDockingStation.side.offsetY, this.currentDockingStation.side.offsetZ);
                } else {
                    this.setSteamDirection(0, -1, 0);
                }
            }
        }
    }

    public void setHealth(float par1) {
    }

    public boolean attackEntityFrom(DamageSource par1, float par2) {
        return false;
    }

    @Override
    public void aimItemAt(int x, int y, int z) {
        this.itemAngle1 = (float)Math.atan2((double)z - Math.floor(this.posZ), (double)x - Math.floor(this.posX));
        this.itemAngle2 = 0.0f;
        if (Math.floor(this.posY) < (double)y) {
            this.itemAngle2 = -0.7853982f;
            if (Math.floor(this.posX) == (double)x && Math.floor(this.posZ) == (double)z) {
                this.itemAngle2 -= 0.7853982f;
            }
        } else if (Math.floor(this.posY) > (double)y) {
            this.itemAngle2 = 1.5707964f;
            if (Math.floor(this.posX) == (double)x && Math.floor(this.posZ) == (double)z) {
                this.itemAngle2 += 0.7853982f;
            }
        }
        int xComp = (int)Math.floor(this.posX);
        int yComp = (int)Math.floor(this.posY);
        int zComp = (int)Math.floor(this.posZ);
        this.setSteamDirection(xComp - x, yComp - y, zComp - z);
        this.updateDataServer();
    }

    @Override
    public void setItemActive(final boolean isActive) {
        if (isActive != this.itemActive) {
            this.itemActive = isActive;
            BuildCraftCore.instance.sendToWorld(new PacketCommand(this, "setItemActive", new CommandWriter(){

                @Override
                public void write(ByteBuf data) {
                    data.writeBoolean(isActive);
                }
            }), this.worldObj);
        }
    }

    @Override
    public RedstoneBoardRobot getBoard() {
        return this.board;
    }

    @Override
    public IDockingStation getLinkedStation() {
        return this.linkedDockingStation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double par1) {
        return true;
    }

    @Override
    public int getEnergy() {
        return this.battery.getEnergyStored();
    }

    @Override
    public RFBattery getBattery() {
        return this.battery;
    }

    protected boolean canDespawn() {
        return false;
    }

    public AIRobot getOverridingAI() {
        return this.mainAI.getOverridingAI();
    }

    public void overrideAI(AIRobot ai) {
        this.mainAI.setOverridingAI(ai);
    }

    public void attackTargetEntityWithCurrentItem(Entity par1Entity) {
        ItemStack stack = this.itemInUse;
        if (par1Entity.canAttackWithItem() && !par1Entity.hitByEntity((Entity)this)) {
            this.setLastAttacker(par1Entity);
            boolean flag2 = par1Entity.attackEntityFrom((DamageSource)new EntityDamageSource("robot", (Entity)this), 2.0f);
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)par1Entity);
            ItemStack itemstack = this.itemInUse;
            Entity object = par1Entity;
            if (itemstack != null && object instanceof EntityLivingBase) {
                itemstack.getItem().hitEntity(itemstack, (EntityLivingBase)object, (EntityLivingBase)this);
            }
        }
    }

    @Override
    public IZone getZoneToWork() {
        if (this.linkedDockingStation instanceof DockingStation) {
            for (StatementSlot s : new ActionIterator(((DockingStation)this.linkedDockingStation).getPipe().pipe)) {
                IZone zone;
                if (!(s.statement instanceof ActionRobotWorkInArea) || (zone = ActionRobotWorkInArea.getArea(s)) == null) continue;
                return zone;
            }
        }
        return null;
    }

    @Override
    public boolean containsItems() {
        for (ItemStack element : this.inv) {
            if (element == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFreeSlot() {
        for (ItemStack element : this.inv) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unreachableEntityDetected(Entity entity) {
        this.unreachableEntities.put(entity, true);
    }

    @Override
    public boolean isKnownUnreachable(Entity entity) {
        return this.unreachableEntities.containsKey(entity);
    }

    public void setDead() {
        if (!this.worldObj.isRemote && !this.isDead) {
            if (this.mainAI != null) {
                this.mainAI.abort();
            }
            ItemStack robotStack = new ItemStack(BuildCraftSilicon.robotItem);
            NBTUtils.getItemData(robotStack).setTag("board", (NBTBase)this.originalBoardNBT);
            NBTUtils.getItemData(robotStack).setInteger("energy", this.battery.getEnergyStored());
            this.entityDropItem(robotStack, 0.0f);
            if (this.itemInUse != null) {
                this.entityDropItem(this.itemInUse, 0.0f);
            }
            for (ItemStack element : this.inv) {
                if (element == null) continue;
                this.entityDropItem(element, 0.0f);
            }
            this.getRegistry().killRobot(this);
        }
        super.setDead();
    }

    @Override
    public void onChunkUnload() {
        this.getRegistry().unloadRobot(this);
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    public void applyEntityCollision(Entity par1Entity) {
    }

    public void setUniqueRobotId(long iRobotId) {
        this.robotId = iRobotId;
    }

    @Override
    public long getRobotId() {
        return this.robotId;
    }

    @Override
    public RobotRegistry getRegistry() {
        return RobotRegistry.getRegistry(this.worldObj);
    }

    @Override
    public void releaseResources() {
        this.getRegistry().releaseResources(this);
    }

    public ItemStack receiveItem(TileEntity tile, ItemStack stack) {
        if (this.currentDockingStation != null && this.currentDockingStation.index().nextTo(new BlockIndex(tile)) && this.mainAI != null) {
            return this.mainAI.getActiveAI().receiveItem(stack);
        }
        return stack;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int result = 0;
        if (this.tank == null) {
            this.tank = new FluidStack(resource.getFluid(), 0);
        }
        if (this.tank.amount + resource.amount <= this.maxFluid) {
            result = resource.amount;
            if (doFill) {
                this.tank.amount += resource.amount;
            }
        } else {
            result = this.maxFluid - this.tank.amount;
            if (doFill) {
                this.tank.amount = this.maxFluid;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.tank != null && this.tank.isFluidEqual(resource)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result = null;
        if (this.tank == null) {
            result = null;
        } else if (this.tank.amount <= maxDrain) {
            result = this.tank.copy();
            if (doDrain) {
                this.tank = null;
            }
        } else {
            result = this.tank.copy();
            result.amount = maxDrain;
            if (doDrain) {
                this.tank.amount -= maxDrain;
            }
        }
        if (this.tank != null && this.tank.amount == 0) {
            this.tank = null;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank == null || this.tank.amount == 0 || this.tank.amount < this.maxFluid && this.tank.getFluid().getID() == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tank != null && this.tank.amount != 0 && this.tank.getFluid().getID() == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.tank, this.maxFluid)};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIcon(ItemStack stack, int renderPass) {
        IIcon iicon = super.getItemIcon(stack, renderPass);
        if (iicon == null) {
            iicon = stack.getItem().getIcon(stack, renderPass, null, this.itemInUse, 0);
        }
        return iicon;
    }
}

