/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityRobotEnergyParticle
extends EntityFX {
    private float smokeParticleScale;

    public EntityRobotEnergyParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        this(world, x, y, z, vx, vy, vz, 1.0f);
    }

    public EntityRobotEnergyParticle(World world, double x, double y, double z, double vx, double vy, double vz, float size) {
        super(world, x, y, z, vx, vy, vz);
        this.motionX *= (double)0.1f;
        this.motionY *= (double)0.1f;
        this.motionZ *= (double)0.1f;
        this.motionX += vx;
        this.motionY += vy;
        this.motionZ += vz;
        this.particleRed = (float)(Math.random() * 0.6);
        this.particleGreen = 0.0f;
        this.particleBlue = 0.0f;
        this.particleScale *= 0.75f;
        this.particleScale *= size;
        this.smokeParticleScale = this.particleScale;
        this.particleMaxAge = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.particleMaxAge = (int)((float)this.particleMaxAge * size);
        this.noClip = false;
    }

    public void renderParticle(Tessellator tesslator, float p2, float p3, float p4, float p5, float p6, float p7) {
        float f6 = ((float)this.particleAge + p2) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.smokeParticleScale * f6;
        super.renderParticle(tesslator, p2, p3, p4, p5, p6, p7);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.98;
        this.motionY += 5.0E-4;
        this.motionZ *= 0.98;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
    }
}

