/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots;

import buildcraft.BuildCraftSilicon;
import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.core.CreativeTabBuildCraft;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.utils.NBTUtils;
import buildcraft.robots.EntityRobot;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ItemRobot
extends ItemBuildCraft
implements IEnergyContainerItem {
    public ItemRobot() {
        super(CreativeTabBuildCraft.BOARDS);
    }

    public EntityRobot createRobot(ItemStack stack, World world) {
        try {
            NBTTagCompound nbt = NBTUtils.getItemData(stack);
            NBTTagCompound boardCpt = nbt.getCompoundTag("board");
            EntityRobot robot = new EntityRobot(world, boardCpt);
            robot.getBattery().setEnergy(nbt.getInteger("energy"));
            return robot;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RedstoneBoardNBT getRobotNBT(ItemStack stack) {
        try {
            NBTTagCompound nbt = NBTUtils.getItemData(stack);
            NBTTagCompound boardCpt = nbt.getCompoundTag("board");
            return RedstoneBoardRegistry.instance.getRedstoneBoard(boardCpt);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResourceLocation getTextureRobot(ItemStack stack) {
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        if (!nbt.hasKey("board")) {
            return EntityRobot.ROBOT_BASE;
        }
        NBTTagCompound board = nbt.getCompoundTag("board");
        RedstoneBoardNBT boardNBT = RedstoneBoardRegistry.instance.getRedstoneBoard(board);
        if (boardNBT instanceof RedstoneBoardRobotNBT) {
            return ((RedstoneBoardRobotNBT)boardNBT).getRobotTexture();
        }
        return EntityRobot.ROBOT_BASE;
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        RedstoneBoardNBT nbt;
        NBTTagCompound cpt = NBTUtils.getItemData(stack).getCompoundTag("board");
        if (cpt.hasKey("id") && !"<unknown>".equals(cpt.getString("id")) && (nbt = RedstoneBoardRegistry.instance.getRedstoneBoard(cpt)) != null) {
            nbt.addInformation(stack, player, list, advanced);
        }
        int energy = NBTUtils.getItemData(stack).getInteger("energy");
        list.add(energy + "/" + 100000 + " RF");
    }

    @Override
    public void registerIcons(IIconRegister par1IconRegister) {
    }

    public static ItemStack createRobotStack(ItemStack board, int energy) {
        ItemStack robot = new ItemStack(BuildCraftSilicon.robotItem);
        NBTUtils.getItemData(robot).setTag("board", (NBTBase)NBTUtils.getItemData(board));
        NBTUtils.getItemData(robot).setInteger("energy", energy);
        return robot;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(BuildCraftSilicon.robotItem));
        for (RedstoneBoardNBT<?> nbt : RedstoneBoardRegistry.instance.getAllBoardNBTs()) {
            ItemStack boardStack = new ItemStack((Item)BuildCraftSilicon.redstoneBoard);
            NBTTagCompound nbtData = NBTUtils.getItemData(boardStack);
            nbt.createBoard(nbtData);
            ItemStack robotStack = ItemRobot.createRobotStack(boardStack, 0);
            itemList.add(robotStack.copy());
            robotStack = ItemRobot.createRobotStack(boardStack, 100000);
            itemList.add(robotStack.copy());
        }
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!container.hasTagCompound()) {
            return 0;
        }
        int currentEnergy = container.getTagCompound().getInteger("energy");
        int energyReceived = Math.min(100000 - currentEnergy, maxReceive);
        if (!simulate) {
            container.getTagCompound().setInteger("energy", currentEnergy + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!container.hasTagCompound()) {
            return 0;
        }
        int currentEnergy = container.getTagCompound().getInteger("energy");
        int energyExtracted = Math.min(currentEnergy, maxExtract);
        if (!simulate) {
            container.getTagCompound().setInteger("energy", currentEnergy - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (!container.hasTagCompound()) {
            return 0;
        }
        return container.getTagCompound().getInteger("energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        if (!container.hasTagCompound()) {
            return 0;
        }
        return 100000;
    }
}

