/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots;

import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IDockingStation;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.ResourceId;
import buildcraft.robots.DockingStation;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.StationIndex;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.ChunkEvent;

public class RobotRegistry
extends WorldSavedData
implements IRobotRegistry {
    public static HashMap<Integer, RobotRegistry> registries = new HashMap();
    protected World world;
    private long nextRobotID = Long.MIN_VALUE;
    private HashMap<Long, EntityRobot> robotsLoaded = new HashMap();
    private HashMap<ResourceId, Long> resourcesTaken = new HashMap();
    private HashMap<Long, HashSet<ResourceId>> resourcesTakenByRobot = new HashMap();
    private HashMap<StationIndex, IDockingStation> stations = new HashMap();
    private HashMap<Long, HashSet<StationIndex>> stationsTakenByRobot = new HashMap();

    public RobotRegistry(String id) {
        super(id);
    }

    @Override
    public long getNextRobotId() {
        long result = this.nextRobotID++;
        return result;
    }

    @Override
    public void registerRobot(EntityRobotBase robot) {
        this.markDirty();
        if (robot.getRobotId() == Long.MAX_VALUE) {
            ((EntityRobot)robot).setUniqueRobotId(this.getNextRobotId());
        }
        this.robotsLoaded.put(robot.getRobotId(), (EntityRobot)robot);
    }

    @Override
    public void killRobot(EntityRobotBase robot) {
        this.markDirty();
        this.releaseResources(robot, true);
        this.robotsLoaded.remove(robot.getRobotId());
    }

    @Override
    public void unloadRobot(EntityRobotBase robot) {
        this.markDirty();
        this.releaseResources(robot, false, true);
        this.robotsLoaded.remove(robot.getRobotId());
    }

    @Override
    public EntityRobot getLoadedRobot(long id) {
        if (this.robotsLoaded.containsKey(id)) {
            return this.robotsLoaded.get(id);
        }
        return null;
    }

    @Override
    public synchronized boolean isTaken(ResourceId resourceId) {
        return this.robotIdTaking(resourceId) != Long.MAX_VALUE;
    }

    @Override
    public synchronized long robotIdTaking(ResourceId resourceId) {
        if (!this.resourcesTaken.containsKey(resourceId)) {
            return Long.MAX_VALUE;
        }
        long robotId = this.resourcesTaken.get(resourceId);
        if (this.robotsLoaded.containsKey(robotId) && !this.robotsLoaded.get((Object)Long.valueOf((long)robotId)).isDead) {
            return robotId;
        }
        this.release(resourceId);
        return Long.MAX_VALUE;
    }

    @Override
    public synchronized EntityRobot robotTaking(ResourceId resourceId) {
        long robotId = this.robotIdTaking(resourceId);
        if (robotId == Long.MAX_VALUE || !this.robotsLoaded.containsKey(robotId)) {
            return null;
        }
        return this.robotsLoaded.get(robotId);
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, EntityRobotBase robot) {
        this.markDirty();
        return this.take(resourceId, robot.getRobotId());
    }

    @Override
    public synchronized boolean take(ResourceId resourceId, long robotId) {
        if (resourceId == null) {
            return false;
        }
        this.markDirty();
        if (!this.resourcesTaken.containsKey(resourceId)) {
            this.resourcesTaken.put(resourceId, robotId);
            if (!this.resourcesTakenByRobot.containsKey(robotId)) {
                this.resourcesTakenByRobot.put(robotId, new HashSet());
            }
            this.resourcesTakenByRobot.get(robotId).add(resourceId);
            resourceId.taken(robotId);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void release(ResourceId resourceId) {
        if (resourceId == null) {
            return;
        }
        this.markDirty();
        if (this.resourcesTaken.containsKey(resourceId)) {
            long robotId = this.resourcesTaken.get(resourceId);
            this.resourcesTakenByRobot.get(this.resourcesTaken.get(resourceId)).remove(resourceId);
            this.resourcesTaken.remove(resourceId);
            resourceId.released(robotId);
        }
    }

    @Override
    public synchronized void releaseResources(EntityRobotBase robot) {
        this.releaseResources(robot, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll) {
        this.releaseResources(robot, forceAll, false);
    }

    private synchronized void releaseResources(EntityRobotBase robot, boolean forceAll, boolean resetEntities) {
        this.markDirty();
        if (this.resourcesTakenByRobot.containsKey(robot.getRobotId())) {
            HashSet resourceSet = (HashSet)this.resourcesTakenByRobot.get(robot.getRobotId()).clone();
            for (ResourceId id : resourceSet) {
                this.release(id);
            }
            this.resourcesTakenByRobot.remove(robot.getRobotId());
        }
        if (this.stationsTakenByRobot.containsKey(robot.getRobotId())) {
            HashSet stationSet = (HashSet)this.stationsTakenByRobot.get(robot.getRobotId()).clone();
            for (StationIndex s : stationSet) {
                DockingStation d = (DockingStation)this.stations.get(s);
                if (d == null) continue;
                if (!d.canRelease()) {
                    if (forceAll) {
                        d.unsafeRelease(robot);
                        continue;
                    }
                    if (!resetEntities || d.robotIdTaking() != robot.getRobotId()) continue;
                    d.invalidateRobotTakingEntity();
                    continue;
                }
                d.unsafeRelease(robot);
            }
            if (forceAll) {
                this.stationsTakenByRobot.remove(robot.getRobotId());
            }
        }
    }

    @Override
    public synchronized IDockingStation getStation(int x, int y, int z, ForgeDirection side) {
        StationIndex index = new StationIndex(side, x, y, z);
        if (this.stations.containsKey(index)) {
            return this.stations.get(index);
        }
        return null;
    }

    @Override
    public synchronized Collection<IDockingStation> getStations() {
        return this.stations.values();
    }

    @Override
    public synchronized void registerStation(IDockingStation station) {
        this.markDirty();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            throw new InvalidParameterException("Station " + index + " already registerd");
        }
        this.stations.put(index, station);
    }

    @Override
    public synchronized void removeStation(IDockingStation station) {
        this.markDirty();
        StationIndex index = new StationIndex(station);
        if (this.stations.containsKey(index)) {
            if (station.robotTaking() != null) {
                station.robotTaking().setDead();
            } else if (station.robotIdTaking() != Long.MAX_VALUE) {
                this.stationsTakenByRobot.get(station.robotIdTaking()).remove(index);
            }
            this.stations.remove(index);
        }
    }

    @Override
    public synchronized void take(IDockingStation station, long robotId) {
        if (!this.stationsTakenByRobot.containsKey(robotId)) {
            this.stationsTakenByRobot.put(robotId, new HashSet());
        }
        this.stationsTakenByRobot.get(robotId).add(new StationIndex(station));
    }

    @Override
    public synchronized void release(IDockingStation station, long robotId) {
        if (this.stationsTakenByRobot.containsKey(robotId)) {
            this.stationsTakenByRobot.get(robotId).remove(new StationIndex(station));
        }
    }

    public static synchronized RobotRegistry getRegistry(World world) {
        if (!registries.containsKey(world.provider.dimensionId) || RobotRegistry.registries.get((Object)Integer.valueOf((int)world.provider.dimensionId)).world != world) {
            RobotRegistry newRegistry = (RobotRegistry)world.perWorldStorage.loadData(RobotRegistry.class, "robotRegistry");
            if (newRegistry == null) {
                newRegistry = new RobotRegistry("robotRegistry");
                world.perWorldStorage.setData("robotRegistry", (WorldSavedData)newRegistry);
            }
            newRegistry.world = world;
            for (IDockingStation d : newRegistry.stations.values()) {
                ((DockingStation)d).world = world;
            }
            MinecraftForge.EVENT_BUS.register((Object)newRegistry);
            registries.put(world.provider.dimensionId, newRegistry);
            return newRegistry;
        }
        return registries.get(world.provider.dimensionId);
    }

    @Override
    public synchronized void writeToNBT(NBTTagCompound nbt) {
        nbt.setLong("nextRobotID", this.nextRobotID);
        NBTTagList resourceList = new NBTTagList();
        for (Map.Entry<ResourceId, Long> e : this.resourcesTaken.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            NBTTagCompound resourceId = new NBTTagCompound();
            e.getKey().writeToNBT(resourceId);
            cpt.setTag("resourceId", (NBTBase)resourceId);
            cpt.setLong("robotId", e.getValue().longValue());
            resourceList.appendTag((NBTBase)cpt);
        }
        nbt.setTag("resourceList", (NBTBase)resourceList);
        NBTTagList stationList = new NBTTagList();
        for (Map.Entry<StationIndex, IDockingStation> e : this.stations.entrySet()) {
            NBTTagCompound cpt = new NBTTagCompound();
            e.getValue().writeToNBT(cpt);
            stationList.appendTag((NBTBase)cpt);
        }
        nbt.setTag("stationList", (NBTBase)stationList);
    }

    @Override
    public synchronized void readFromNBT(NBTTagCompound nbt) {
        this.nextRobotID = nbt.getLong("nextRobotID");
        NBTTagList resourceList = nbt.getTagList("resourceList", 10);
        for (int i = 0; i < resourceList.tagCount(); ++i) {
            NBTTagCompound cpt = resourceList.getCompoundTagAt(i);
            ResourceId resourceId = ResourceId.load(cpt.getCompoundTag("resourceId"));
            long robotId = cpt.getLong("robotId");
            this.take(resourceId, robotId);
        }
        NBTTagList stationList = nbt.getTagList("stationList", 10);
        for (int i = 0; i < stationList.tagCount(); ++i) {
            NBTTagCompound cpt = stationList.getCompoundTagAt(i);
            DockingStation station = new DockingStation();
            station.readFromNBT(cpt);
            this.registerStation(station);
            if (station.linkedId() == Long.MAX_VALUE) continue;
            this.take(station, station.linkedId());
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload e) {
        if (e.world == this.world) {
            for (EntityRobot robot : new ArrayList<EntityRobot>(this.robotsLoaded.values())) {
                if (e.world.loadedEntityList.contains(robot)) continue;
                robot.onChunkUnload();
            }
        }
    }
}

