/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robots.EntityRobot;
import buildcraft.robots.ai.AIRobotGotoBlock;
import net.minecraft.entity.Entity;

public class AIRobotAttack
extends AIRobot {
    public Entity target;
    private int delay = 10;

    public AIRobotAttack(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotAttack(EntityRobotBase iRobot, Entity iTarget) {
        super(iRobot);
        this.target = iTarget;
    }

    @Override
    public void preempt(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock && this.target != null && (double)this.robot.getDistanceToEntity(this.target) <= 2.0) {
            this.abortDelegateAI();
            this.robot.setItemActive(true);
        }
    }

    @Override
    public void update() {
        if (this.target.isDead) {
            this.terminate();
            return;
        }
        if ((double)this.robot.getDistanceToEntity(this.target) > 2.0) {
            this.startDelegateAI(new AIRobotGotoBlock(this.robot, (int)Math.floor(this.target.posX), (int)Math.floor(this.target.posY), (int)Math.floor(this.target.posZ)));
            this.robot.setItemActive(false);
            return;
        }
        ++this.delay;
        if (this.delay > 20) {
            this.delay = 0;
            ((EntityRobot)this.robot).attackTargetEntityWithCurrentItem(this.target);
            this.robot.aimItemAt((int)Math.floor(this.target.posX), (int)Math.floor(this.target.posY), (int)Math.floor(this.target.posZ));
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoBlock) {
            AIRobotGotoBlock aiGoto = (AIRobotGotoBlock)ai;
            if (((AIRobotGotoBlock)ai).unreachable) {
                this.robot.unreachableEntityDetected(this.target);
            }
            this.terminate();
        }
    }

    @Override
    public int getEnergyCost() {
        return 16;
    }
}

