/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;

public class AIRobotBreak
extends AIRobot {
    public BlockIndex blockToBreak;
    private float blockDamage = 0.0f;
    private Block block;
    private int meta;
    private float hardness;
    private float speed;

    public AIRobotBreak(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotBreak(EntityRobotBase iRobot, BlockIndex iBlockToBreak) {
        super(iRobot);
        this.blockToBreak = iBlockToBreak;
    }

    @Override
    public void start() {
        this.robot.aimItemAt(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.robot.setItemActive(true);
        this.block = this.robot.worldObj.getBlock(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.meta = this.robot.worldObj.getBlockMetadata(this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.hardness = this.block.getBlockHardness(this.robot.worldObj, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z);
        this.speed = this.getBreakSpeed(this.robot, this.robot.getHeldItem(), this.block, this.meta);
    }

    @Override
    public void update() {
        if (this.block == null || this.block.isAir((IBlockAccess)this.robot.worldObj, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z)) {
            this.terminate();
        }
        this.blockDamage = this.hardness != 0.0f ? (this.blockDamage += this.speed / this.hardness / 30.0f) : 1.1f;
        if (this.blockDamage > 1.0f) {
            this.robot.worldObj.destroyBlockInWorldPartially(this.robot.getEntityId(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, -1);
            this.blockDamage = 0.0f;
            if (this.robot.getHeldItem() != null) {
                this.robot.getHeldItem().getItem().onBlockStartBreak(this.robot.getHeldItem(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.worldObj).get());
            }
            if (BlockUtils.breakBlock((WorldServer)this.robot.worldObj, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, 6000)) {
                this.robot.worldObj.playAuxSFXAtEntity(null, 2001, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, Block.getIdFromBlock((Block)this.block) + (this.meta << 12));
                if (this.robot.getHeldItem() != null) {
                    this.robot.getHeldItem().getItem().onBlockDestroyed(this.robot.getHeldItem(), this.robot.worldObj, this.block, this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (EntityLivingBase)this.robot);
                    if (this.robot.getHeldItem().getItemDamage() >= this.robot.getHeldItem().getMaxDamage()) {
                        this.robot.setItemInUse(null);
                    }
                }
            }
            this.terminate();
        } else {
            this.robot.worldObj.destroyBlockInWorldPartially(this.robot.getEntityId(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, (int)(this.blockDamage * 10.0f) - 1);
        }
    }

    @Override
    public void end() {
        this.robot.setItemActive(false);
        this.robot.worldObj.destroyBlockInWorldPartially(this.robot.getEntityId(), this.blockToBreak.x, this.blockToBreak.y, this.blockToBreak.z, -1);
    }

    private float getBreakSpeed(EntityRobotBase robot, ItemStack usingItem, Block block, int meta) {
        float f;
        ItemStack stack = usingItem;
        float f2 = f = stack == null ? 1.0f : stack.getItem().getDigSpeed(stack, block, meta);
        if (f > 1.0f) {
            int i = EnchantmentHelper.getEfficiencyModifier((EntityLivingBase)robot);
            ItemStack itemstack = usingItem;
            if (i > 0 && itemstack != null) {
                float f1 = i * i + 1;
                boolean canHarvest = ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)itemstack);
                f = !canHarvest && f <= 1.0f ? (f += f1 * 0.08f) : (f += f1);
            }
        }
        return f;
    }

    @Override
    public int getEnergyCost() {
        return (int)Math.ceil(10.666666984558105);
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockToBreak != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockToBreak.writeTo(sub);
            nbt.setTag("blockToBreak", (NBTBase)sub);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.hasKey("blockToBreak")) {
            this.blockToBreak = new BlockIndex(nbt.getCompoundTag("blockToBreak"));
        }
    }
}

