/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.ArrayStackFilter;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.robots.DockingStation;
import buildcraft.robots.IStationFilter;
import buildcraft.robots.ResourceIdBlock;
import buildcraft.robots.ai.AIRobotCraftGeneric;
import buildcraft.robots.ai.AIRobotGotoStation;
import buildcraft.robots.ai.AIRobotGotoStationAndLoad;
import buildcraft.robots.ai.AIRobotGotoStationAndUnload;
import buildcraft.robots.ai.AIRobotSearchStation;
import buildcraft.robots.statements.ActionRobotFilter;
import buildcraft.robots.statements.ActionStationAllowCraft;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotCraftFurnace
extends AIRobotCraftGeneric {
    private static final int INPUT_SLOT = 0;
    private static final int FUEL_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private ItemStack input;
    private DockingStation stationFound;
    private TileEntityFurnace furnace;
    private boolean craftStarted = false;
    private int waitedTime = 0;
    private ItemStack expectedOutput;

    public AIRobotCraftFurnace(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotCraftFurnace(EntityRobotBase iRobot, ItemStack iInput, ItemStack iOutput) {
        super(iRobot);
        this.input = iInput;
        this.expectedOutput = iOutput;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotSearchStation(this.robot, new StationFurnaceFilter(), this.robot.getZoneToWork()));
    }

    @Override
    public void update() {
        if (this.furnace != null) {
            if (!this.craftStarted) {
                IInvSlot s;
                if (this.furnace.getStackInSlot(1) == null && InvUtils.getItem(this.robot, new FuelFilter()) == null) {
                    this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new FuelFilter(), this.robot.getZoneToWork()));
                    return;
                }
                if (InvUtils.getItem(this.robot, new ArrayStackFilter(this.input)) == null) {
                    this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, new ArrayStackFilter(this.input), this.robot.getZoneToWork()));
                    return;
                }
                if (this.robot.getDockingStation() != this.stationFound) {
                    this.startDelegateAI(new AIRobotGotoStation(this.robot, this.stationFound));
                    return;
                }
                if (this.furnace.getStackInSlot(1) == null) {
                    s = InvUtils.getItem(this.robot, new FuelFilter());
                    this.furnace.setInventorySlotContents(1, s.decreaseStackInSlot(1));
                }
                if (this.furnace.getStackInSlot(0) == null) {
                    s = InvUtils.getItem(this.robot, new ArrayStackFilter(this.input));
                    this.furnace.setInventorySlotContents(0, s.decreaseStackInSlot(1));
                }
                this.craftStarted = true;
                if (!this.robot.hasFreeSlot()) {
                    this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
                }
            } else {
                ++this.waitedTime;
                if (this.waitedTime > 40 && this.furnace.getStackInSlot(2) != null) {
                    ItemStack stack;
                    if (this.robot.hasFreeSlot() && (stack = this.furnace.decrStackSize(2, 1)) != null) {
                        ITransactor transactor = Transactor.getTransactorFor((Object)this.robot);
                        transactor.add(stack, ForgeDirection.UNKNOWN, true);
                        this.crafted = true;
                    }
                    this.terminate();
                } else if (this.waitedTime > 1200) {
                    this.terminate();
                }
            }
        } else {
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchStation) {
            if (!ai.success()) {
                this.crafted = false;
                this.terminate();
            } else {
                this.stationFound = ((AIRobotSearchStation)ai).targetStation;
                this.furnace = this.getUsableFurnace(new BlockIndex(this.stationFound.x(), this.stationFound.y(), this.stationFound.z()));
                if (this.furnace == null) {
                    this.terminate();
                    return;
                }
                BlockIndex index = new BlockIndex((TileEntity)this.furnace);
                if (!this.robot.getRegistry().take((ResourceId)new ResourceIdBlock(index), this.robot)) {
                    this.terminate();
                }
                if (!this.stationFound.take(this.robot)) {
                    this.terminate();
                }
            }
        } else if (ai instanceof AIRobotGotoStationAndLoad) {
            // empty if block
        }
    }

    private TileEntityFurnace getUsableFurnace(BlockIndex b) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityFurnace f;
            Block nearbyBlock;
            BlockIndex index = new BlockIndex(b.x + dir.offsetX, b.y + dir.offsetY, b.z + dir.offsetZ);
            if (this.robot.getRegistry().isTaken(new ResourceIdBlock(index)) || !((nearbyBlock = this.robot.worldObj.getBlock(index.x, index.y, index.z)) instanceof BlockFurnace) || (f = (TileEntityFurnace)this.robot.worldObj.getTileEntity(index.x, index.y, index.z)).getStackInSlot(0) != null && !StackHelper.isMatchingItem(this.input, f.getStackInSlot(0))) continue;
            return f;
        }
        return null;
    }

    private class FuelFilter
    implements IStackFilter {
        private FuelFilter() {
        }

        @Override
        public boolean matches(ItemStack stack) {
            return TileEntityFurnace.getItemBurnTime((ItemStack)stack) > 0 && !StackHelper.isMatchingItem(stack, AIRobotCraftFurnace.this.input);
        }
    }

    private class StationFurnaceFilter
    implements IStationFilter {
        private StationFurnaceFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithItem(station, new ArrayStackFilter(AIRobotCraftFurnace.this.expectedOutput), ActionStationAllowCraft.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (AIRobotCraftFurnace.this.getUsableFurnace(new BlockIndex(station.x(), station.y(), station.z())) == null) continue;
                return true;
            }
            return false;
        }
    }
}

