/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.api.robots.StackRequest;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.filters.ArrayStackOrListFilter;
import buildcraft.robots.DockingStation;
import buildcraft.robots.IStationFilter;
import buildcraft.robots.ai.AIRobotGotoStation;
import buildcraft.robots.ai.AIRobotUnload;
import buildcraft.robots.statements.ActionStationRequestItemsMachine;
import buildcraft.transport.Pipe;
import buildcraft.transport.gates.ActionIterator;
import buildcraft.transport.gates.StatementSlot;
import net.minecraft.item.ItemStack;

public class AIRobotDeliverRequested
extends AIRobot {
    private StackRequest requested;
    private boolean delivered = false;

    public AIRobotDeliverRequested(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotDeliverRequested(EntityRobotBase robot, StackRequest request) {
        super(robot);
        this.requested = request;
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotGotoStation(this.robot, this.requested.station));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (!(ai instanceof AIRobotGotoStation)) {
            if (!(ai instanceof AIRobotUnload)) return;
            this.delivered = ai.success();
            this.terminate();
            return;
        }
        if (!ai.success()) {
            this.terminate();
            return;
        }
        IInvSlot slot = InvUtils.getItem(this.robot, new ArrayStackOrListFilter(this.requested.stack));
        if (slot == null) {
            this.terminate();
            return;
        }
        if (this.requested.requester == null) {
            this.startDelegateAI(new AIRobotUnload(this.robot));
            return;
        }
        ItemStack newStack = ((IRequestProvider)this.requested.requester).provideItemsForRequest(this.requested.index, slot.getStackInSlot().copy());
        if (newStack == null || newStack.stackSize != slot.getStackInSlot().stackSize) {
            this.delivered = true;
            slot.setStackInSlot(newStack);
        }
        this.terminate();
    }

    @Override
    public boolean success() {
        return this.delivered;
    }

    private class StationProviderFilter
    implements IStationFilter {
        private StationProviderFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            boolean actionFound = false;
            Pipe pipe = station.getPipe().pipe;
            if (!station.index().nextTo(new BlockIndex(((AIRobotDeliverRequested)AIRobotDeliverRequested.this).requested.requester))) {
                return false;
            }
            for (StatementSlot s : new ActionIterator(pipe)) {
                if (!(s.statement instanceof ActionStationRequestItemsMachine)) continue;
                actionFound = true;
            }
            return actionFound;
        }
    }
}

