/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.utils.concurrency.IterableAlgorithmRunner;
import buildcraft.core.utils.concurrency.PathFinding;
import buildcraft.robots.ai.AIRobotGoto;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AIRobotGotoBlock
extends AIRobotGoto {
    public boolean unreachable = false;
    private PathFinding pathSearch;
    private IterableAlgorithmRunner pathSearchJob;
    private LinkedList<BlockIndex> path;
    private double prevDistance = Double.MAX_VALUE;
    private float finalX;
    private float finalY;
    private float finalZ;
    private double maxDistance = 0.0;
    private BlockIndex lastBlockInPath;

    public AIRobotGotoBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoBlock(EntityRobotBase robot, int x, int y, int z) {
        super(robot);
        this.finalX = x;
        this.finalY = y;
        this.finalZ = z;
        robot.aimItemAt((int)Math.floor(this.finalX), (int)Math.floor(this.finalY), (int)Math.floor(this.finalZ));
    }

    public AIRobotGotoBlock(EntityRobotBase robot, int x, int y, int z, double iMaxDistance) {
        this(robot, x, y, z);
        this.maxDistance = iMaxDistance;
    }

    public AIRobotGotoBlock(EntityRobotBase robot, LinkedList<BlockIndex> iPath) {
        super(robot);
        this.path = iPath;
        this.finalX = this.path.getLast().x;
        this.finalY = this.path.getLast().y;
        this.finalZ = this.path.getLast().z;
        robot.aimItemAt((int)Math.floor(this.finalX), (int)Math.floor(this.finalY), (int)Math.floor(this.finalZ));
        this.setNextInPath();
    }

    @Override
    public void start() {
        this.robot.undock();
    }

    @Override
    public void update() {
        if (this.path == null && this.pathSearch == null) {
            this.pathSearch = new PathFinding(this.robot.worldObj, new BlockIndex((int)Math.floor(this.robot.posX), (int)Math.floor(this.robot.posY), (int)Math.floor(this.robot.posZ)), new BlockIndex((int)Math.floor(this.finalX), (int)Math.floor(this.finalY), (int)Math.floor(this.finalZ)), this.maxDistance);
            this.pathSearchJob = new IterableAlgorithmRunner(this.pathSearch, 100);
            this.pathSearchJob.start();
        } else if (this.path != null) {
            double distance = this.robot.getDistance(this.nextX, this.nextY, this.nextZ);
            if (!this.robot.isMoving() || distance > this.prevDistance) {
                if (this.path.size() > 0) {
                    this.path.removeFirst();
                }
                this.setNextInPath();
            } else {
                this.prevDistance = this.robot.getDistance(this.nextX, this.nextY, this.nextZ);
            }
        } else if (this.pathSearchJob.isDone()) {
            this.path = this.pathSearch.getResult();
            if (this.path.size() == 0) {
                this.unreachable = true;
                this.terminate();
                return;
            }
            this.lastBlockInPath = this.path.getLast();
            this.setNextInPath();
        }
        if (this.path != null && this.path.size() == 0) {
            this.robot.motionX = 0.0;
            this.robot.motionY = 0.0;
            this.robot.motionZ = 0.0;
            if (this.lastBlockInPath != null) {
                this.robot.posX = (float)this.lastBlockInPath.x + 0.5f;
                this.robot.posY = (float)this.lastBlockInPath.y + 0.5f;
                this.robot.posZ = (float)this.lastBlockInPath.z + 0.5f;
            }
            this.terminate();
        }
    }

    private void setNextInPath() {
        if (this.path.size() > 0) {
            BlockIndex next = this.path.getFirst();
            this.setDestination(this.robot, (float)next.x + 0.5f, (float)next.y + 0.5f, (float)next.z + 0.5f);
            this.prevDistance = Double.MAX_VALUE;
        }
    }

    @Override
    public void end() {
        if (this.pathSearchJob != null) {
            this.pathSearchJob.terminate();
            this.robot.motionX = 0.0;
            this.robot.motionY = 0.0;
            this.robot.motionZ = 0.0;
        }
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.setFloat("finalX", this.finalX);
        nbt.setFloat("finalY", this.finalY);
        nbt.setFloat("finalZ", this.finalZ);
        nbt.setDouble("maxDistance", this.maxDistance);
        if (this.path != null) {
            NBTTagList pathList = new NBTTagList();
            for (BlockIndex i : this.path) {
                NBTTagCompound subNBT = new NBTTagCompound();
                i.writeTo(subNBT);
                pathList.appendTag((NBTBase)subNBT);
            }
            nbt.setTag("path", (NBTBase)pathList);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.finalX = nbt.getFloat("finalX");
        this.finalY = nbt.getFloat("finalY");
        this.finalZ = nbt.getFloat("finalZ");
        this.maxDistance = nbt.getDouble("maxDistance");
        if (nbt.hasKey("path")) {
            NBTTagList pathList = nbt.getTagList("path", 10);
            this.path = new LinkedList();
            for (int i = 0; i < pathList.tagCount(); ++i) {
                this.path.add(new BlockIndex(pathList.getCompoundTagAt(i)));
            }
            this.setNextInPath();
        }
    }
}

