/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robots.DockingStation;
import buildcraft.robots.ai.AIRobotGotoStation;
import buildcraft.robots.ai.AIRobotGotoStationToUnload;
import buildcraft.robots.ai.AIRobotUnload;

public class AIRobotGotoStationAndUnload
extends AIRobot {
    private boolean found = false;
    private IZone zone;
    private DockingStation station;

    public AIRobotGotoStationAndUnload(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationAndUnload(EntityRobotBase iRobot, IZone iZone) {
        super(iRobot);
        this.zone = iZone;
    }

    public AIRobotGotoStationAndUnload(EntityRobotBase iRobot, DockingStation iStation) {
        super(iRobot);
        this.station = iStation;
    }

    @Override
    public void start() {
        if (this.station == null) {
            this.startDelegateAI(new AIRobotGotoStationToUnload(this.robot, this.zone));
        } else {
            this.startDelegateAI(new AIRobotGotoStation(this.robot, this.station));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToUnload) {
            if (ai.success()) {
                this.found = true;
                this.startDelegateAI(new AIRobotUnload(this.robot));
            } else {
                this.terminate();
            }
        } else if (ai instanceof AIRobotGotoStation) {
            if (ai.success()) {
                this.found = true;
                this.startDelegateAI(new AIRobotUnload(this.robot));
            } else {
                this.terminate();
            }
        }
    }

    @Override
    public boolean success() {
        return this.found;
    }
}

