/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.SimpleFluidFilter;
import buildcraft.robots.DockingStation;
import buildcraft.robots.IStationFilter;
import buildcraft.robots.ai.AIRobotSearchAndGotoStation;
import buildcraft.robots.statements.ActionRobotFilter;
import buildcraft.robots.statements.ActionStationAcceptFluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotGotoStationToUnloadFluids
extends AIRobot {
    private boolean found = false;
    private IZone zone;

    public AIRobotGotoStationToUnloadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotGotoStationToUnloadFluids(EntityRobotBase iRobot, IZone iZone) {
        super(iRobot);
        this.zone = iZone;
    }

    @Override
    public void update() {
        this.startDelegateAI(new AIRobotSearchAndGotoStation(this.robot, new StationFilter(), this.zone));
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoStation) {
            this.found = ((AIRobotSearchAndGotoStation)ai).targetStation != null;
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.found;
    }

    private class StationFilter
    implements IStationFilter {
        private StationFilter() {
        }

        @Override
        public boolean matches(DockingStation station) {
            if (!ActionRobotFilter.canInteractWithFluid(station, new SimpleFluidFilter(AIRobotGotoStationToUnloadFluids.this.robot.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid), ActionStationAcceptFluids.class)) {
                return false;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                FluidStack drainable;
                IFluidHandler handler;
                int filledAmount;
                TileEntity nearbyTile = AIRobotGotoStationToUnloadFluids.this.robot.worldObj.getTileEntity(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IFluidHandler) || (filledAmount = (handler = (IFluidHandler)nearbyTile).fill(station.side, drainable = AIRobotGotoStationToUnloadFluids.this.robot.drain(ForgeDirection.UNKNOWN, 1, false), false)) <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

