/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.ITransactor;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.Transactor;
import buildcraft.core.inventory.filters.IStackFilter;
import buildcraft.robots.DockingStation;
import buildcraft.robots.statements.ActionRobotFilter;
import buildcraft.robots.statements.ActionStationProvideItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotLoad
extends AIRobot {
    private IStackFilter filter;
    private int quantity = -1;
    private int waitedCycles = 0;

    public AIRobotLoad(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotLoad(EntityRobotBase iRobot, IStackFilter iFilter) {
        super(iRobot);
        this.filter = iFilter;
    }

    public AIRobotLoad(EntityRobotBase iRobot, IStackFilter iFilter, int iQuantity) {
        super(iRobot);
        this.filter = iFilter;
        this.quantity = iQuantity;
    }

    @Override
    public void update() {
        if (this.filter == null) {
            this.terminate();
            return;
        }
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            this.doLoad();
            this.terminate();
        }
    }

    private void doLoad() {
        if (this.robot.getDockingStation() != null) {
            DockingStation station = (DockingStation)this.robot.getDockingStation();
            int loaded = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity nearbyTile = this.robot.worldObj.getTileEntity(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IInventory)) continue;
                IInventory tileInventory = (IInventory)nearbyTile;
                ITransactor robotTransactor = Transactor.getTransactorFor((Object)this.robot);
                for (IInvSlot slot : InventoryIterator.getIterable(tileInventory, dir.getOpposite())) {
                    ItemStack stack = slot.getStackInSlot();
                    if (stack == null || !ActionRobotFilter.canInteractWithItem(station, this.filter, ActionStationProvideItems.class) || !this.filter.matches(stack)) continue;
                    ITransactor t = Transactor.getTransactorFor((Object)this.robot);
                    if (this.quantity == -1) {
                        ItemStack added = t.add(slot.getStackInSlot(), ForgeDirection.UNKNOWN, true);
                        slot.decreaseStackInSlot(added.stackSize);
                        continue;
                    }
                    ItemStack toAdd = slot.getStackInSlot().copy();
                    if (toAdd.stackSize > this.quantity - loaded) {
                        toAdd.stackSize = this.quantity - loaded;
                    }
                    ItemStack added = t.add(toAdd, ForgeDirection.UNKNOWN, true);
                    slot.decreaseStackInSlot(added.stackSize);
                    if (this.quantity - (loaded += added.stackSize) > 0) continue;
                    return;
                }
            }
        }
    }

    @Override
    public int getEnergyCost() {
        return 8;
    }
}

