/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robots.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.inventory.filters.IFluidFilter;
import buildcraft.robots.DockingStation;
import buildcraft.robots.statements.ActionRobotFilter;
import buildcraft.robots.statements.ActionStationProvideFluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotLoadFluids
extends AIRobot {
    private int loaded = 0;
    private int waitedCycles = 0;
    private IFluidFilter filter;

    public AIRobotLoadFluids(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotLoadFluids(EntityRobotBase iRobot, IFluidFilter iFilter) {
        super(iRobot);
        this.filter = iFilter;
    }

    @Override
    public void update() {
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            int previousLoaded = this.loaded;
            this.doLoad();
            if (this.loaded == previousLoaded) {
                this.terminate();
            } else {
                this.waitedCycles = 0;
            }
        }
    }

    private void doLoad() {
        if (this.robot.getDockingStation() != null) {
            DockingStation station = (DockingStation)this.robot.getDockingStation();
            if (!ActionRobotFilter.canInteractWithFluid(station, this.filter, ActionStationProvideFluids.class)) {
                return;
            }
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                int filled;
                IFluidHandler handler;
                FluidStack drainable;
                TileEntity nearbyTile = this.robot.worldObj.getTileEntity(station.x() + dir.offsetX, station.y() + dir.offsetY, station.z() + dir.offsetZ);
                if (nearbyTile == null || !(nearbyTile instanceof IFluidHandler) || (drainable = (handler = (IFluidHandler)nearbyTile).drain(station.side, 1000, false)) == null || !this.filter.matches(drainable.getFluid()) || (filled = this.robot.fill(ForgeDirection.UNKNOWN, drainable = drainable.copy(), true)) <= 0) continue;
                drainable.amount = filled;
                handler.drain(station.side, drainable, true);
                this.loaded += filled;
                return;
            }
        }
    }

    @Override
    public int getEnergyCost() {
        return 8;
    }

    @Override
    public boolean success() {
        return this.loaded > 0;
    }
}

